/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.streams.websockets;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.opendaylight.restconf.nb.rfc8040.streams.listeners.Notificator;
import org.opendaylight.restconf.nb.rfc8040.streams.websockets.WebSocketServerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSocketServer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketServer.class);
    private static WebSocketServer instance = null;
    private final int port;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    private WebSocketServer(int port) {
        this.port = port;
    }

    public static WebSocketServer createInstance(int port) {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"createInstance() has already been called");
        Preconditions.checkArgument((port >= 1024 ? 1 : 0) != 0, (Object)"Privileged port (below 1024) is not allowed");
        instance = new WebSocketServer(port);
        return instance;
    }

    public int getPort() {
        return this.port;
    }

    public static WebSocketServer getInstance() {
        Preconditions.checkNotNull((Object)instance, (Object)"createInstance() must be called prior to getInstance()");
        return instance;
    }

    public static void destroyInstance() {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"createInstance() must be called prior to destroyInstance()");
        instance.stop();
        instance = null;
    }

    @Override
    public void run() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new WebSocketServerInitializer());
            Channel channel = serverBootstrap.bind(this.port).sync().channel();
            LOG.info("Web socket server started at port {}.", (Object)this.port);
            channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            LOG.error("Web socket server encountered an error during startup attempt on port {}", (Object)this.port, (Object)e);
        }
        catch (Throwable throwable) {
            LOG.error("Error while binding to port {}", (Object)this.port, (Object)throwable);
            throw throwable;
        }
        finally {
            this.stop();
        }
    }

    private void stop() {
        LOG.debug("Stopping the web socket server instance on port {}", (Object)this.port);
        Notificator.removeAllListeners();
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.bossGroup = null;
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
    }
}

