/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.utils.mapping;

import java.net.URI;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.nb.rfc8040.Rfc8040;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.ParserIdentifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.Module;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

public final class RestconfMappingNodeUtil {
    private RestconfMappingNodeUtil() {
        throw new UnsupportedOperationException("Util class");
    }

    public static NormalizedNode<YangInstanceIdentifier.NodeIdentifier, Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>>> mapModulesByIetfYangLibraryYang(Set<Module> modules, Module ietfYangLibraryModule, SchemaContext context, String moduleSetId) {
        DataSchemaNode modulesStateSch = ietfYangLibraryModule.getDataChildByName(Rfc8040.IetfYangLibrary.MODUELS_STATE_CONT_QNAME);
        DataContainerNodeAttrBuilder modulesStateBuilder = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)modulesStateSch));
        DataSchemaNode moduleSetIdSch = ((ContainerSchemaNode)modulesStateSch).getDataChildByName(Rfc8040.IetfYangLibrary.MODULE_SET_ID_LEAF_QNAME);
        modulesStateBuilder.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)moduleSetIdSch)).withValue((Object)moduleSetId).build());
        DataSchemaNode moduleSch = RestconfMappingNodeUtil.findNodeInGroupings(Rfc8040.IetfYangLibrary.MODULE_QNAME_LIST, ietfYangLibraryModule);
        CollectionNodeBuilder mapBuilder = Builders.orderedMapBuilder((ListSchemaNode)((ListSchemaNode)moduleSch));
        for (Module module : context.getModules()) {
            RestconfMappingNodeUtil.fillMapByModules((CollectionNodeBuilder<MapEntryNode, OrderedMapNode>)mapBuilder, moduleSch, false, module, ietfYangLibraryModule, context);
        }
        return modulesStateBuilder.withChild((DataContainerChild)mapBuilder.build()).build();
    }

    private static void fillMapByModules(CollectionNodeBuilder<MapEntryNode, OrderedMapNode> mapBuilder, DataSchemaNode moduleSch, boolean isSubmodule, Module module, Module ietfYangLibraryModule, SchemaContext context) {
        DataContainerNodeAttrBuilder mapEntryBuilder = Builders.mapEntryBuilder((ListSchemaNode)((ListSchemaNode)moduleSch));
        RestconfMappingNodeUtil.addCommonLeafs(module, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder, ietfYangLibraryModule);
        RestconfMappingNodeUtil.addChildOfModuleBySpecificModuleInternal(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_SCHEMA_LEAF_QNAME, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder, "/modules/" + module.getName() + "/" + (String)module.getQNameModule().getRevision().map(Revision::toString).orElse(null), ietfYangLibraryModule);
        if (!isSubmodule) {
            RestconfMappingNodeUtil.addChildOfModuleBySpecificModuleOfListChild(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_NAMESPACE_LEAF_QNAME, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder, module.getNamespace().toString(), ietfYangLibraryModule);
            if (module.getFeatures() != null && !module.getFeatures().isEmpty()) {
                RestconfMappingNodeUtil.addFeatureLeafList(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_FEATURE_LEAF_LIST_QNAME, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder, module.getFeatures(), ietfYangLibraryModule);
            }
            if (module.getDeviations() != null && !module.getDeviations().isEmpty()) {
                RestconfMappingNodeUtil.addDeviationList(module, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder, ietfYangLibraryModule, context);
                RestconfMappingNodeUtil.addChildOfModuleBySpecificModuleOfListChild(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_CONFORMANCE_LEAF_QNAME, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder, Module.ConformanceType.Implement.getName(), ietfYangLibraryModule);
            } else {
                RestconfMappingNodeUtil.addChildOfModuleBySpecificModuleOfListChild(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_CONFORMANCE_LEAF_QNAME, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder, Module.ConformanceType.Import.getName(), ietfYangLibraryModule);
            }
            if (module.getSubmodules() != null && !module.getSubmodules().isEmpty()) {
                RestconfMappingNodeUtil.addSubmodules(module, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)mapEntryBuilder, ietfYangLibraryModule, context);
            }
        }
        mapBuilder.withChild(mapEntryBuilder.build());
    }

    private static void addSubmodules(Module module, DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder, Module ietfYangLibraryModule, SchemaContext context) {
        DataSchemaNode listSubm = RestconfMappingNodeUtil.findSchemaInListOfModulesSchema(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_SUBMODULE_LIST_QNAME, ietfYangLibraryModule);
        CollectionNodeBuilder mapBuilder = Builders.orderedMapBuilder((ListSchemaNode)((ListSchemaNode)listSubm));
        for (Module submodule : module.getSubmodules()) {
            RestconfMappingNodeUtil.fillMapByModules((CollectionNodeBuilder<MapEntryNode, OrderedMapNode>)mapBuilder, listSubm, true, submodule, ietfYangLibraryModule, context);
        }
        mapEntryBuilder.withChild((DataContainerChild)mapBuilder.build());
    }

    private static void addDeviationList(Module module, DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder, Module ietfYangLibraryModule, SchemaContext context) {
        DataSchemaNode deviationsSchema = RestconfMappingNodeUtil.findSchemaInListOfModulesSchema(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_DEVIATION_LIST_QNAME, ietfYangLibraryModule);
        CollectionNodeBuilder deviations = Builders.mapBuilder((ListSchemaNode)((ListSchemaNode)deviationsSchema));
        for (Deviation deviation : module.getDeviations()) {
            DataContainerNodeAttrBuilder deviationEntryNode = Builders.mapEntryBuilder((ListSchemaNode)((ListSchemaNode)deviationsSchema));
            QName lastComponent = deviation.getTargetPath().getLastComponent();
            RestconfMappingNodeUtil.addChildOfModuleBySpecificModule(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_NAME_LEAF_QNAME, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)deviationEntryNode, ((Module)context.findModule(lastComponent.getModule()).get()).getName(), ietfYangLibraryModule);
            RestconfMappingNodeUtil.addChildOfModuleBySpecificModule(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_REVISION_LEAF_QNAME, (DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)deviationEntryNode, lastComponent.getRevision(), ietfYangLibraryModule);
            deviations.withChild(deviationEntryNode.build());
        }
        mapEntryBuilder.withChild((DataContainerChild)deviations.build());
    }

    private static void addFeatureLeafList(QName qnameOfFeaturesLeafList, DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder, Set<FeatureDefinition> features, Module ietfYangLibraryModule) {
        DataSchemaNode schemaNode = RestconfMappingNodeUtil.findSchemaInListOfModulesSchema(qnameOfFeaturesLeafList, ietfYangLibraryModule);
        ListNodeBuilder leafSetBuilder = Builders.leafSetBuilder((LeafListSchemaNode)((LeafListSchemaNode)schemaNode));
        for (FeatureDefinition feature : features) {
            leafSetBuilder.withChild((LeafSetEntryNode)Builders.leafSetEntryBuilder((LeafListSchemaNode)((LeafListSchemaNode)schemaNode)).withValue((Object)feature.getQName().getLocalName()).build());
        }
        mapEntryBuilder.withChild((DataContainerChild)leafSetBuilder.build());
    }

    private static void addCommonLeafs(Module module, DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder, Module ietfYangLibraryModule) {
        RestconfMappingNodeUtil.addChildOfModuleBySpecificModuleInternal(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_NAME_LEAF_QNAME, mapEntryBuilder, module.getName(), ietfYangLibraryModule);
        RestconfMappingNodeUtil.addChildOfModuleBySpecificModuleInternal(Rfc8040.IetfYangLibrary.SPECIFIC_MODULE_REVISION_LEAF_QNAME, mapEntryBuilder, module.getQNameModule().getRevision().map(Revision::toString).orElse(""), ietfYangLibraryModule);
    }

    private static void addChildOfModuleBySpecificModuleOfListChild(QName specificQName, DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder, Object value, Module ietfYangLibraryModule) {
        DataSchemaNode leafSch = RestconfMappingNodeUtil.findSchemaInListOfModulesSchema(specificQName, ietfYangLibraryModule);
        mapEntryBuilder.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)leafSch)).withValue(value).build());
    }

    private static DataSchemaNode findSchemaInListOfModulesSchema(QName specificQName, Module ietfYangLibraryModule) {
        for (GroupingDefinition groupingDefinition : ietfYangLibraryModule.getGroupings()) {
            if (!groupingDefinition.getQName().equals((Object)Rfc8040.IetfYangLibrary.GROUPING_MODULE_LIST_QNAME)) continue;
            DataSchemaNode dataChildByName = groupingDefinition.getDataChildByName(Rfc8040.IetfYangLibrary.MODULE_QNAME_LIST);
            return ((ListSchemaNode)dataChildByName).getDataChildByName(specificQName);
        }
        throw new RestconfDocumentedException(specificQName.getLocalName() + " doesn't exist.");
    }

    private static void addChildOfModuleBySpecificModuleInternal(QName specifiLeafQName, DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder, Object value, Module ietfYangLibraryModule) {
        DataSchemaNode nameLeaf = RestconfMappingNodeUtil.findNodeInInternGroupings(specifiLeafQName, ietfYangLibraryModule);
        mapEntryBuilder.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)nameLeaf)).withValue(value).build());
    }

    private static DataSchemaNode findNodeInInternGroupings(QName qnameOfSchema, Module ietfYangLibraryModule) {
        for (GroupingDefinition groupingDefinition : ietfYangLibraryModule.getGroupings()) {
            if (!groupingDefinition.getQName().equals((Object)Rfc8040.IetfYangLibrary.GROUPING_MODULE_LIST_QNAME)) continue;
            for (GroupingDefinition internalGrouping : groupingDefinition.getGroupings()) {
                if (internalGrouping.getDataChildByName(qnameOfSchema) == null) continue;
                return internalGrouping.getDataChildByName(qnameOfSchema);
            }
        }
        throw new RestconfDocumentedException(qnameOfSchema.getLocalName() + " doesn't exist.");
    }

    private static void addChildOfModuleBySpecificModule(QName specifiLeafQName, DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder, Object value, Module ietfYangLibraryModule) {
        DataSchemaNode nameLeaf = RestconfMappingNodeUtil.findNodeInGroupings(specifiLeafQName, ietfYangLibraryModule);
        mapEntryBuilder.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)nameLeaf)).withValue(value).build());
    }

    private static DataSchemaNode findNodeInGroupings(QName qnameOfSchema, Module ietfYangLibraryModule) {
        for (GroupingDefinition groupingDefinition : ietfYangLibraryModule.getGroupings()) {
            if (groupingDefinition.getDataChildByName(qnameOfSchema) == null) continue;
            return groupingDefinition.getDataChildByName(qnameOfSchema);
        }
        throw new RestconfDocumentedException(qnameOfSchema.getLocalName() + " doesn't exist.");
    }

    public static NormalizedNode<YangInstanceIdentifier.NodeIdentifier, Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>>> mapCapabilites(Module monitoringModule) {
        DataSchemaNode restconfState = monitoringModule.getDataChildByName(Rfc8040.MonitoringModule.CONT_RESTCONF_STATE_QNAME);
        DataContainerNodeAttrBuilder restStateContBuilder = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)restconfState));
        DataSchemaNode capabilitesContSchema = RestconfMappingNodeUtil.getChildOfCont((ContainerSchemaNode)restconfState, Rfc8040.MonitoringModule.CONT_CAPABILITES_QNAME);
        DataContainerNodeAttrBuilder capabilitesContBuilder = Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)capabilitesContSchema));
        DataSchemaNode leafListCapa = RestconfMappingNodeUtil.getChildOfCont((ContainerSchemaNode)capabilitesContSchema, Rfc8040.MonitoringModule.LEAF_LIST_CAPABILITY_QNAME);
        ListNodeBuilder leafListCapaBuilder = Builders.orderedLeafSetBuilder((LeafListSchemaNode)((LeafListSchemaNode)leafListCapa));
        RestconfMappingNodeUtil.fillLeafListCapa(leafListCapaBuilder, (LeafListSchemaNode)leafListCapa);
        return restStateContBuilder.withChild((DataContainerChild)capabilitesContBuilder.withChild((DataContainerChild)leafListCapaBuilder.build()).build()).build();
    }

    private static void fillLeafListCapa(ListNodeBuilder builder, LeafListSchemaNode leafListSchema) {
        builder.withChild(RestconfMappingNodeUtil.leafListEntryBuild(leafListSchema, "urn:ietf:params:restconf:capability:depth:1.0"));
        builder.withChild(RestconfMappingNodeUtil.leafListEntryBuild(leafListSchema, "urn:ietf:params:restconf:capability:fields:1.0"));
        builder.withChild(RestconfMappingNodeUtil.leafListEntryBuild(leafListSchema, "urn:ietf:params:restconf:capability:filter:1.0"));
        builder.withChild(RestconfMappingNodeUtil.leafListEntryBuild(leafListSchema, "urn:ietf:params:restconf:capability:replay:1.0"));
        builder.withChild(RestconfMappingNodeUtil.leafListEntryBuild(leafListSchema, "urn:ietf:params:restconf:capability:with-defaults:1.0"));
    }

    private static LeafSetEntryNode leafListEntryBuild(LeafListSchemaNode leafListSchema, String value) {
        return (LeafSetEntryNode)Builders.leafSetEntryBuilder((LeafListSchemaNode)leafListSchema).withValue((Object)value).build();
    }

    private static DataSchemaNode getChildOfCont(ContainerSchemaNode parent, QName childQName) {
        for (DataSchemaNode child : parent.getChildNodes()) {
            if (!child.getQName().equals((Object)childQName)) continue;
            return child;
        }
        throw new RestconfDocumentedException(childQName.getLocalName() + " doesn't exist in container " + "restconf-state");
    }

    public static NormalizedNode mapYangNotificationStreamByIetfRestconfMonitoring(QName notifiQName, Set<NotificationDefinition> notifications, Instant start, String outputType, URI uri, Module monitoringModule, boolean existParent) {
        for (NotificationDefinition notificationDefinition : notifications) {
            if (!notificationDefinition.getQName().equals((Object)notifiQName)) continue;
            DataSchemaNode streamListSchema = ((ContainerSchemaNode)((ContainerSchemaNode)monitoringModule.getDataChildByName(Rfc8040.MonitoringModule.CONT_RESTCONF_STATE_QNAME)).getDataChildByName(Rfc8040.MonitoringModule.CONT_STREAMS_QNAME)).getDataChildByName(Rfc8040.MonitoringModule.LIST_STREAM_QNAME);
            DataContainerNodeAttrBuilder streamEntry = Builders.mapEntryBuilder((ListSchemaNode)((ListSchemaNode)streamListSchema));
            ListSchemaNode listSchema = (ListSchemaNode)streamListSchema;
            RestconfMappingNodeUtil.prepareLeafAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)streamEntry, listSchema.getDataChildByName(Rfc8040.MonitoringModule.LEAF_NAME_STREAM_QNAME), notificationDefinition.getQName().getLocalName());
            Optional optDesc = notificationDefinition.getDescription();
            if (optDesc.isPresent()) {
                RestconfMappingNodeUtil.prepareLeafAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)streamEntry, listSchema.getDataChildByName(Rfc8040.MonitoringModule.LEAF_DESCR_STREAM_QNAME), optDesc.get());
            }
            RestconfMappingNodeUtil.prepareLeafAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)streamEntry, listSchema.getDataChildByName(Rfc8040.MonitoringModule.LEAF_REPLAY_SUPP_STREAM_QNAME), true);
            if (start != null) {
                RestconfMappingNodeUtil.prepareLeafAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)streamEntry, listSchema.getDataChildByName(Rfc8040.MonitoringModule.LEAF_START_TIME_STREAM_QNAME), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.ofInstant(start, ZoneId.systemDefault())));
            }
            RestconfMappingNodeUtil.prepareListAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)streamEntry, (ListSchemaNode)listSchema.getDataChildByName(Rfc8040.MonitoringModule.LIST_ACCESS_STREAM_QNAME), outputType, uri);
            if (!existParent) {
                DataSchemaNode contStreamsSchema = ((ContainerSchemaNode)monitoringModule.getDataChildByName(Rfc8040.MonitoringModule.CONT_RESTCONF_STATE_QNAME)).getDataChildByName(Rfc8040.MonitoringModule.CONT_STREAMS_QNAME);
                return Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)contStreamsSchema)).withChild((DataContainerChild)Builders.mapBuilder((ListSchemaNode)((ListSchemaNode)streamListSchema)).withChild(streamEntry.build()).build()).build();
            }
            return streamEntry.build();
        }
        throw new RestconfDocumentedException(notifiQName + " doesn't exist in any modul");
    }

    private static void prepareListAndFillEntryBuilder(DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> streamEntry, ListSchemaNode listSchemaNode, String outputType, URI uriToWebsocketServer) {
        CollectionNodeBuilder accessListBuilder = Builders.mapBuilder((ListSchemaNode)listSchemaNode);
        DataContainerNodeAttrBuilder entryAccessList = Builders.mapEntryBuilder((ListSchemaNode)listSchemaNode);
        RestconfMappingNodeUtil.prepareLeafAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)entryAccessList, listSchemaNode.getDataChildByName(Rfc8040.MonitoringModule.LEAF_ENCODING_ACCESS_QNAME), outputType);
        RestconfMappingNodeUtil.prepareLeafAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)entryAccessList, listSchemaNode.getDataChildByName(Rfc8040.MonitoringModule.LEAF_LOCATION_ACCESS_QNAME), uriToWebsocketServer.toString());
        streamEntry.withChild((DataContainerChild)accessListBuilder.withChild(entryAccessList.build()).build());
    }

    private static void prepareLeafAndFillEntryBuilder(DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> streamEntry, DataSchemaNode leafSchema, Object value) {
        streamEntry.withChild((DataContainerChild)Builders.leafBuilder((LeafSchemaNode)((LeafSchemaNode)leafSchema)).withValue(value).build());
    }

    public static NormalizedNode mapDataChangeNotificationStreamByIetfRestconfMonitoring(YangInstanceIdentifier path, Instant start, String outputType, URI uri, Module monitoringModule, boolean existParent, SchemaContext schemaContext) {
        SchemaNode schemaNode = ParserIdentifier.toInstanceIdentifier(ParserIdentifier.stringFromYangInstanceIdentifier(path, schemaContext), schemaContext, Optional.empty()).getSchemaNode();
        DataSchemaNode streamListSchema = ((ContainerSchemaNode)((ContainerSchemaNode)monitoringModule.getDataChildByName(Rfc8040.MonitoringModule.CONT_RESTCONF_STATE_QNAME)).getDataChildByName(Rfc8040.MonitoringModule.CONT_STREAMS_QNAME)).getDataChildByName(Rfc8040.MonitoringModule.LIST_STREAM_QNAME);
        DataContainerNodeAttrBuilder streamEntry = Builders.mapEntryBuilder((ListSchemaNode)((ListSchemaNode)streamListSchema));
        ListSchemaNode listSchema = (ListSchemaNode)streamListSchema;
        RestconfMappingNodeUtil.prepareLeafAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)streamEntry, listSchema.getDataChildByName(Rfc8040.MonitoringModule.LEAF_NAME_STREAM_QNAME), schemaNode.getQName().getLocalName());
        Optional optDesc = schemaNode.getDescription();
        if (optDesc.isPresent()) {
            RestconfMappingNodeUtil.prepareLeafAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)streamEntry, listSchema.getDataChildByName(Rfc8040.MonitoringModule.LEAF_DESCR_STREAM_QNAME), optDesc.get());
        }
        RestconfMappingNodeUtil.prepareLeafAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)streamEntry, listSchema.getDataChildByName(Rfc8040.MonitoringModule.LEAF_REPLAY_SUPP_STREAM_QNAME), true);
        RestconfMappingNodeUtil.prepareLeafAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)streamEntry, listSchema.getDataChildByName(Rfc8040.MonitoringModule.LEAF_START_TIME_STREAM_QNAME), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.ofInstant(start, ZoneId.systemDefault())));
        RestconfMappingNodeUtil.prepareListAndFillEntryBuilder((DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>)streamEntry, (ListSchemaNode)listSchema.getDataChildByName(Rfc8040.MonitoringModule.LIST_ACCESS_STREAM_QNAME), outputType, uri);
        if (!existParent) {
            DataSchemaNode contStreamsSchema = ((ContainerSchemaNode)monitoringModule.getDataChildByName(Rfc8040.MonitoringModule.CONT_RESTCONF_STATE_QNAME)).getDataChildByName(Rfc8040.MonitoringModule.CONT_STREAMS_QNAME);
            return Builders.containerBuilder((ContainerSchemaNode)((ContainerSchemaNode)contStreamsSchema)).withChild((DataContainerChild)Builders.mapBuilder((ListSchemaNode)((ListSchemaNode)streamListSchema)).withChild(streamEntry.build()).build()).build();
        }
        return streamEntry.build();
    }
}

