/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.utils.parser;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Locale;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.builder.ParserBuilderConstants;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class YangInstanceIdentifierSerializer {
    private YangInstanceIdentifierSerializer() {
        throw new UnsupportedOperationException("Util class.");
    }

    public static String create(SchemaContext schemaContext, YangInstanceIdentifier data) {
        DataSchemaContextNode current = DataSchemaContextTree.from((SchemaContext)schemaContext).getRoot();
        MainVarsWrapper variables = new MainVarsWrapper(current);
        StringBuilder path = new StringBuilder();
        QNameModule parentModule = null;
        for (int i = 0; i < data.getPathArguments().size(); ++i) {
            if (!variables.getCurrent().isMixin()) {
                parentModule = variables.getCurrent().getDataSchemaNode().getQName().getModule();
            }
            YangInstanceIdentifier.PathArgument arg = (YangInstanceIdentifier.PathArgument)data.getPathArguments().get(i);
            variables.setCurrent(variables.getCurrent().getChild(arg));
            Preconditions.checkArgument((variables.getCurrent() != null ? 1 : 0) != 0, (String)"Invalid input %s: schema for argument %s (after %s) not found", (Object)data, (Object)arg, (Object)path);
            if (variables.getCurrent().isMixin()) continue;
            if (!arg.getNodeType().getModule().equals((Object)parentModule)) {
                if (path.length() > 0) {
                    path.append('/');
                }
                path.append(YangInstanceIdentifierSerializer.prefixForNamespace(arg.getNodeType(), schemaContext));
                path.append(':');
            } else {
                path.append('/');
            }
            if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                YangInstanceIdentifierSerializer.prepareNodeWithPredicates(path, arg);
                continue;
            }
            if (arg instanceof YangInstanceIdentifier.NodeWithValue) {
                YangInstanceIdentifierSerializer.prepareNodeWithValue(path, arg);
                continue;
            }
            YangInstanceIdentifierSerializer.appendQName(path, arg.getNodeType());
        }
        return path.toString();
    }

    private static void prepareNodeWithValue(StringBuilder path, YangInstanceIdentifier.PathArgument arg) {
        path.append(arg.getNodeType().getLocalName());
        path.append('=');
        String value = String.valueOf(((YangInstanceIdentifier.NodeWithValue)arg).getValue());
        if (ParserBuilderConstants.Serializer.PERCENT_ENCODE_CHARS.matchesAnyOf((CharSequence)value)) {
            value = YangInstanceIdentifierSerializer.parsePercentEncodeChars(value);
        }
        path.append(value);
    }

    private static void prepareNodeWithPredicates(StringBuilder path, YangInstanceIdentifier.PathArgument arg) {
        path.append(arg.getNodeType().getLocalName());
        Iterator iterator = ((YangInstanceIdentifier.NodeIdentifierWithPredicates)arg).getKeyValues().entrySet().iterator();
        if (iterator.hasNext()) {
            path.append('=');
        }
        while (iterator.hasNext()) {
            String valueOf = String.valueOf(iterator.next().getValue());
            if (ParserBuilderConstants.Serializer.PERCENT_ENCODE_CHARS.matchesAnyOf((CharSequence)valueOf)) {
                valueOf = YangInstanceIdentifierSerializer.parsePercentEncodeChars(valueOf);
            }
            path.append(valueOf);
            if (!iterator.hasNext()) continue;
            path.append(',');
        }
    }

    private static String parsePercentEncodeChars(String valueOf) {
        StringBuilder sb = new StringBuilder();
        for (int start = 0; start < valueOf.length(); ++start) {
            if (ParserBuilderConstants.Serializer.PERCENT_ENCODE_CHARS.matches(valueOf.charAt(start))) {
                String format = String.format("%x", valueOf.charAt(start));
                String upperCase = format.toUpperCase(Locale.ROOT);
                sb.append('%' + upperCase);
                continue;
            }
            sb.append(valueOf.charAt(start));
        }
        return sb.toString();
    }

    private static StringBuilder appendQName(StringBuilder path, QName qname) {
        path.append(qname.getLocalName());
        return path;
    }

    private static String prefixForNamespace(QName qname, SchemaContext schemaContext) {
        Module module = schemaContext.findModule(qname.getModule()).orElse(null);
        return module.getName();
    }

    private static final class MainVarsWrapper {
        private DataSchemaContextNode<?> current;

        MainVarsWrapper(DataSchemaContextNode<?> current) {
            this.setCurrent(current);
        }

        public DataSchemaContextNode<?> getCurrent() {
            return this.current;
        }

        public void setCurrent(DataSchemaContextNode<?> current) {
            this.current = current;
        }
    }
}

