/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.utils.parser.builder;

import com.google.common.base.CharMatcher;
import java.util.Arrays;

public final class ParserBuilderConstants {
    private ParserBuilderConstants() {
        throw new UnsupportedOperationException("Util class");
    }

    public static final class Deserializer {
        public static final CharMatcher BASE = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).precomputed();
        public static final CharMatcher IDENTIFIER_FIRST_CHAR = BASE.or(CharMatcher.is((char)'_')).precomputed();
        public static final CharMatcher IDENTIFIER = IDENTIFIER_FIRST_CHAR.or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)".-")).precomputed();
        public static final CharMatcher IDENTIFIER_HEXA = CharMatcher.inRange((char)'a', (char)'f').or(CharMatcher.inRange((char)'A', (char)'F')).or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();
        public static final char COLON = ':';
        public static final char EQUAL = '=';
        public static final char COMMA = ',';
        public static final char HYPHEN = '-';
        public static final char PERCENT_ENCODING = '%';
        public static final CharMatcher IDENTIFIER_PREDICATE = CharMatcher.noneOf((CharSequence)Serializer.DISABLED_CHARS).precomputed();
        public static final String EMPTY_STRING = "";
        public static final int FIRST_ENCODED_CHAR = 1;
        public static final int LAST_ENCODED_CHAR = 3;
        public static final int PERCENT_ENCODED_RADIX = 16;

        private Deserializer() {
            throw new UnsupportedOperationException("Util class");
        }
    }

    public static final class Serializer {
        public static final String DISABLED_CHARS = Arrays.toString(new char[]{':', '/', '?', '#', '[', ']', '@'}).concat(Arrays.toString(new char[]{'!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '='}));
        public static final CharMatcher PERCENT_ENCODE_CHARS = CharMatcher.anyOf((CharSequence)DISABLED_CHARS).precomputed();

        private Serializer() {
            throw new UnsupportedOperationException("Util class");
        }
    }
}

