/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.utils.validations;

import java.time.format.DateTimeParseException;
import java.util.Iterator;
import java.util.Locale;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.restconf.common.errors.RestconfError;
import org.opendaylight.restconf.common.validation.RestconfValidationUtils;
import org.opendaylight.restconf.nb.rfc8040.utils.parser.builder.ParserBuilderConstants;
import org.opendaylight.yangtools.yang.common.Revision;

public final class RestconfValidation {
    private RestconfValidation() {
        throw new UnsupportedOperationException("Util class.");
    }

    public static Revision validateAndGetRevision(Iterator<String> revisionDate) {
        RestconfValidationUtils.checkDocumentedError((boolean)revisionDate.hasNext(), (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.INVALID_VALUE, (String)"Revision date must be supplied.");
        try {
            return Revision.of((String)revisionDate.next());
        }
        catch (DateTimeParseException e) {
            throw new RestconfDocumentedException("Supplied revision is not in expected date format YYYY-mm-dd", (Throwable)e);
        }
    }

    public static String validateAndGetModulName(Iterator<String> moduleName) {
        RestconfValidationUtils.checkDocumentedError((boolean)moduleName.hasNext(), (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.INVALID_VALUE, (String)"Module name must be supplied.");
        String name = moduleName.next();
        RestconfValidationUtils.checkDocumentedError((!name.isEmpty() && ParserBuilderConstants.Deserializer.IDENTIFIER_FIRST_CHAR.matches(name.charAt(0)) ? 1 : 0) != 0, (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.INVALID_VALUE, (String)"Identifier must start with character from set 'a-zA-Z_");
        RestconfValidationUtils.checkDocumentedError((!name.toUpperCase(Locale.ROOT).startsWith("XML") ? 1 : 0) != 0, (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.INVALID_VALUE, (String)"Identifier must NOT start with XML ignore case.");
        RestconfValidationUtils.checkDocumentedError((boolean)ParserBuilderConstants.Deserializer.IDENTIFIER.matchesAllOf((CharSequence)name.substring(1)), (RestconfError.ErrorType)RestconfError.ErrorType.PROTOCOL, (RestconfError.ErrorTag)RestconfError.ErrorTag.INVALID_VALUE, (String)"Supplied name has not expected identifier format.");
        return name;
    }
}

