/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.restconf.nb.rfc8040.web;

import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.servlets.GzipFilter;
import org.opendaylight.aaa.filterchain.configuration.CustomFilterAdapterConfiguration;
import org.opendaylight.aaa.filterchain.filters.CustomFilterAdapter;
import org.opendaylight.aaa.web.FilterDetails;
import org.opendaylight.aaa.web.ServletDetails;
import org.opendaylight.aaa.web.WebContext;
import org.opendaylight.aaa.web.WebContextBuilder;
import org.opendaylight.aaa.web.WebContextRegistration;
import org.opendaylight.aaa.web.WebContextSecurer;
import org.opendaylight.aaa.web.WebServer;
import org.opendaylight.aaa.web.servlet.ServletSupport;

public class WebInitializer {
    private final WebContextRegistration registration;

    public WebInitializer(WebServer webServer, WebContextSecurer webContextSecurer, ServletSupport servletSupport, Application webApp, CustomFilterAdapterConfiguration customFilterAdapterConfig) throws ServletException {
        WebContextBuilder webContextBuilder = WebContext.builder().contextPath("rests").supportsSessions(true).addServlet(ServletDetails.builder().servlet((Servlet)servletSupport.createHttpServletBuilder(webApp).build()).addUrlPattern("/*").build()).addFilter(FilterDetails.builder().filter((Filter)new CustomFilterAdapter(customFilterAdapterConfig)).addUrlPattern("/*").build()).addFilter(FilterDetails.builder().filter((Filter)new GzipFilter()).putInitParam("mimeTypes", "application/xml,application/yang.data+xml,xml,application/json,application/yang.data+json").addUrlPattern("/*").build());
        webContextSecurer.requireAuthentication(webContextBuilder, new String[]{"/*"});
        this.registration = webServer.registerWebContext(webContextBuilder.build());
    }

    public void close() {
        if (this.registration != null) {
            this.registration.close();
        }
    }
}

