/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.common.impl.util.compat;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationException;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeAttrBuilder;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;

@Deprecated
public abstract class DataNormalizationOperation<T extends YangInstanceIdentifier.PathArgument>
implements Identifiable<T> {
    private final T identifier;
    private final Optional<DataSchemaNode> dataSchemaNode;

    public T getIdentifier() {
        return this.identifier;
    }

    protected DataNormalizationOperation(T identifier, SchemaNode schema) {
        this.identifier = identifier;
        this.dataSchemaNode = schema instanceof DataSchemaNode ? Optional.of((Object)((DataSchemaNode)schema)) : Optional.absent();
    }

    public boolean isMixin() {
        return false;
    }

    public boolean isKeyedEntry() {
        return false;
    }

    protected Set<QName> getQNameIdentifiers() {
        return Collections.singleton(this.identifier.getNodeType());
    }

    public abstract DataNormalizationOperation<?> getChild(YangInstanceIdentifier.PathArgument var1) throws DataNormalizationException;

    public abstract DataNormalizationOperation<?> getChild(QName var1) throws DataNormalizationException;

    public abstract boolean isLeaf();

    public Optional<DataSchemaNode> getDataSchemaNode() {
        return this.dataSchemaNode;
    }

    private static Optional<DataSchemaNode> findChildSchemaNode(DataNodeContainer parent, QName child) {
        DataSchemaNode potential = parent.getDataChildByName(child);
        if (potential == null) {
            FluentIterable choices = FluentIterable.from((Iterable)parent.getChildNodes()).filter(ChoiceSchemaNode.class);
            potential = DataNormalizationOperation.findChoice((Iterable<ChoiceSchemaNode>)choices, child);
        }
        return Optional.fromNullable((Object)potential);
    }

    private static DataNormalizationOperation<?> fromSchemaAndQNameChecked(DataNodeContainer schema, QName child) throws DataNormalizationException {
        Optional<DataSchemaNode> potential = DataNormalizationOperation.findChildSchemaNode(schema, child);
        if (!potential.isPresent()) {
            throw new DataNormalizationException(String.format("Supplied QName %s is not valid according to schema %s, potential children nodes: %s", child, schema, schema.getChildNodes()));
        }
        DataSchemaNode result = (DataSchemaNode)potential.get();
        if (schema instanceof DataSchemaNode && result.isAugmenting()) {
            return DataNormalizationOperation.fromAugmentation(schema, (AugmentationTarget)schema, result);
        }
        return DataNormalizationOperation.fromDataSchemaNode(result);
    }

    private static ChoiceSchemaNode findChoice(Iterable<ChoiceSchemaNode> choices, QName child) {
        ChoiceSchemaNode foundChoice = null;
        block0: for (ChoiceSchemaNode choice : choices) {
            for (CaseSchemaNode caze : choice.getCases().values()) {
                if (!DataNormalizationOperation.findChildSchemaNode((DataNodeContainer)caze, child).isPresent()) continue;
                foundChoice = choice;
                break block0;
            }
        }
        return foundChoice;
    }

    public static YangInstanceIdentifier.AugmentationIdentifier augmentationIdentifierFrom(AugmentationSchemaNode augmentation) {
        ImmutableSet.Builder potentialChildren = ImmutableSet.builder();
        for (DataSchemaNode child : augmentation.getChildNodes()) {
            potentialChildren.add((Object)child.getQName());
        }
        return new YangInstanceIdentifier.AugmentationIdentifier((Set)potentialChildren.build());
    }

    private static DataNodeContainer augmentationProxy(AugmentationSchemaNode augmentation, DataNodeContainer schema) {
        HashSet<DataSchemaNode> children = new HashSet<DataSchemaNode>();
        for (DataSchemaNode augNode : augmentation.getChildNodes()) {
            children.add(schema.getDataChildByName(augNode.getQName()));
        }
        return new EffectiveAugmentationSchema(augmentation, children);
    }

    private static DataNormalizationOperation<?> fromAugmentation(DataNodeContainer parent, AugmentationTarget parentAug, DataSchemaNode child) {
        AugmentationSchemaNode augmentation = null;
        for (AugmentationSchemaNode aug : parentAug.getAvailableAugmentations()) {
            DataSchemaNode potential = aug.getDataChildByName(child.getQName());
            if (potential == null) continue;
            augmentation = aug;
            break;
        }
        if (augmentation != null) {
            return new AugmentationNormalization(augmentation, parent);
        }
        return DataNormalizationOperation.fromDataSchemaNode(child);
    }

    public static DataNormalizationOperation<?> fromDataSchemaNode(DataSchemaNode potential) {
        if (potential instanceof ContainerSchemaNode) {
            return new ContainerNormalization((ContainerSchemaNode)potential);
        }
        if (potential instanceof ListSchemaNode) {
            return DataNormalizationOperation.fromListSchemaNode((ListSchemaNode)potential);
        }
        if (potential instanceof LeafSchemaNode) {
            return new LeafNormalization((LeafSchemaNode)potential);
        }
        if (potential instanceof ChoiceSchemaNode) {
            return new ChoiceNodeNormalization((ChoiceSchemaNode)potential);
        }
        if (potential instanceof LeafListSchemaNode) {
            return DataNormalizationOperation.fromLeafListSchemaNode((LeafListSchemaNode)potential);
        }
        if (potential instanceof AnyXmlSchemaNode) {
            return new AnyXmlNormalization((AnyXmlSchemaNode)potential);
        }
        return null;
    }

    private static DataNormalizationOperation<?> fromListSchemaNode(ListSchemaNode potential) {
        List keyDefinition = potential.getKeyDefinition();
        if (keyDefinition == null || keyDefinition.isEmpty()) {
            return new UnkeyedListMixinNormalization(potential);
        }
        if (potential.isUserOrdered()) {
            return new OrderedMapMixinNormalization(potential);
        }
        return new UnorderedMapMixinNormalization(potential);
    }

    private static DataNormalizationOperation<?> fromLeafListSchemaNode(LeafListSchemaNode potential) {
        if (potential.isUserOrdered()) {
            return new OrderedLeafListMixinNormalization(potential);
        }
        return new UnorderedLeafListMixinNormalization(potential);
    }

    public static DataNormalizationOperation<?> from(SchemaContext ctx) {
        return new ContainerNormalization((ContainerSchemaNode)ctx);
    }

    public abstract NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument var1);

    private static class AnyXmlNormalization
    extends DataNormalizationOperation<YangInstanceIdentifier.NodeIdentifier> {
        protected AnyXmlNormalization(AnyXmlSchemaNode schema) {
            super(new YangInstanceIdentifier.NodeIdentifier(schema.getQName()), (SchemaNode)schema);
        }

        @Override
        public DataNormalizationOperation<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return null;
        }

        @Override
        public DataNormalizationOperation<?> getChild(QName child) {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return null;
        }
    }

    private static class ChoiceNodeNormalization
    extends MixinNormalizationOp<YangInstanceIdentifier.NodeIdentifier> {
        private final ImmutableMap<QName, DataNormalizationOperation<?>> byQName;
        private final ImmutableMap<YangInstanceIdentifier.PathArgument, DataNormalizationOperation<?>> byArg;

        protected ChoiceNodeNormalization(ChoiceSchemaNode schema) {
            super(new YangInstanceIdentifier.NodeIdentifier(schema.getQName()), (DataSchemaNode)schema);
            ImmutableMap.Builder byQNameBuilder = ImmutableMap.builder();
            ImmutableMap.Builder byArgBuilder = ImmutableMap.builder();
            for (CaseSchemaNode caze : schema.getCases().values()) {
                for (DataSchemaNode cazeChild : caze.getChildNodes()) {
                    DataNormalizationOperation<?> childOp = ChoiceNodeNormalization.fromDataSchemaNode(cazeChild);
                    byArgBuilder.put(childOp.getIdentifier(), childOp);
                    for (QName qname : childOp.getQNameIdentifiers()) {
                        byQNameBuilder.put((Object)qname, childOp);
                    }
                }
            }
            this.byQName = byQNameBuilder.build();
            this.byArg = byArgBuilder.build();
        }

        @Override
        public DataNormalizationOperation<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return (DataNormalizationOperation)this.byArg.get((Object)child);
        }

        @Override
        public DataNormalizationOperation<?> getChild(QName child) {
            return (DataNormalizationOperation)this.byQName.get((Object)child);
        }

        @Override
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return Builders.choiceBuilder().withNodeIdentifier(((DataNormalizationOperation)this).getIdentifier()).build();
        }
    }

    private static final class OrderedMapMixinNormalization
    extends UnorderedMapMixinNormalization {
        OrderedMapMixinNormalization(ListSchemaNode list) {
            super(list);
        }

        @Override
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return Builders.orderedMapBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((DataNormalizationOperation)this).getIdentifier()).build();
        }
    }

    private static class UnkeyedListMixinNormalization
    extends MixinNormalizationOp<YangInstanceIdentifier.NodeIdentifier> {
        private final UnkeyedListItemNormalization innerNode;

        UnkeyedListMixinNormalization(ListSchemaNode list) {
            super(new YangInstanceIdentifier.NodeIdentifier(list.getQName()), (DataSchemaNode)list);
            this.innerNode = new UnkeyedListItemNormalization(list);
        }

        @Override
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return Builders.unkeyedListBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((DataNormalizationOperation)this).getIdentifier()).build();
        }

        @Override
        public DataNormalizationOperation<?> getChild(YangInstanceIdentifier.PathArgument child) {
            if (child.getNodeType().equals((Object)((YangInstanceIdentifier.NodeIdentifier)((DataNormalizationOperation)this).getIdentifier()).getNodeType())) {
                return this.innerNode;
            }
            return null;
        }

        @Override
        public DataNormalizationOperation<?> getChild(QName child) {
            if (((YangInstanceIdentifier.NodeIdentifier)((DataNormalizationOperation)this).getIdentifier()).getNodeType().equals((Object)child)) {
                return this.innerNode;
            }
            return null;
        }
    }

    private static class UnorderedMapMixinNormalization
    extends MixinNormalizationOp<YangInstanceIdentifier.NodeIdentifier> {
        private final ListItemNormalization innerNode;

        UnorderedMapMixinNormalization(ListSchemaNode list) {
            super(new YangInstanceIdentifier.NodeIdentifier(list.getQName()), (DataSchemaNode)list);
            this.innerNode = new ListItemNormalization(new YangInstanceIdentifier.NodeIdentifierWithPredicates(list.getQName(), Collections.emptyMap()), list);
        }

        @Override
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return Builders.mapBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((DataNormalizationOperation)this).getIdentifier()).build();
        }

        @Override
        public DataNormalizationOperation<?> getChild(YangInstanceIdentifier.PathArgument child) {
            if (child.getNodeType().equals((Object)((YangInstanceIdentifier.NodeIdentifier)((DataNormalizationOperation)this).getIdentifier()).getNodeType())) {
                return this.innerNode;
            }
            return null;
        }

        @Override
        public DataNormalizationOperation<?> getChild(QName child) {
            if (((YangInstanceIdentifier.NodeIdentifier)((DataNormalizationOperation)this).getIdentifier()).getNodeType().equals((Object)child)) {
                return this.innerNode;
            }
            return null;
        }
    }

    private static final class AugmentationNormalization
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.AugmentationIdentifier> {
        AugmentationNormalization(AugmentationSchemaNode augmentation, DataNodeContainer schema) {
            super(AugmentationNormalization.augmentationIdentifierFrom(augmentation), DataNormalizationOperation.augmentationProxy(augmentation, schema), null);
        }

        @Override
        public boolean isMixin() {
            return true;
        }

        @Override
        protected DataNormalizationOperation<?> fromLocalSchemaAndQName(DataNodeContainer schema, QName child) {
            Optional potential = DataNormalizationOperation.findChildSchemaNode(schema, child);
            if (!potential.isPresent()) {
                return null;
            }
            DataSchemaNode result = (DataSchemaNode)potential.get();
            if (schema instanceof DataSchemaNode && result.isAugmenting()) {
                return DataNormalizationOperation.fromAugmentation(schema, (AugmentationTarget)schema, result);
            }
            return AugmentationNormalization.fromDataSchemaNode(result);
        }

        @Override
        protected Set<QName> getQNameIdentifiers() {
            return ((YangInstanceIdentifier.AugmentationIdentifier)((DataNormalizationOperation)this).getIdentifier()).getPossibleChildNames();
        }

        @Override
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return Builders.augmentationBuilder().withNodeIdentifier(((DataNormalizationOperation)this).getIdentifier()).build();
        }
    }

    private static class UnorderedLeafListMixinNormalization
    extends MixinNormalizationOp<YangInstanceIdentifier.NodeIdentifier> {
        private final DataNormalizationOperation<?> innerOp;

        UnorderedLeafListMixinNormalization(LeafListSchemaNode potential) {
            super(new YangInstanceIdentifier.NodeIdentifier(potential.getQName()), (DataSchemaNode)potential);
            this.innerOp = new LeafListEntryNormalization(potential);
        }

        @Override
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return Builders.leafSetBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((DataNormalizationOperation)this).getIdentifier()).build();
        }

        @Override
        public DataNormalizationOperation<?> getChild(YangInstanceIdentifier.PathArgument child) {
            if (child instanceof YangInstanceIdentifier.NodeWithValue) {
                return this.innerOp;
            }
            return null;
        }

        @Override
        public DataNormalizationOperation<?> getChild(QName child) {
            if (((YangInstanceIdentifier.NodeIdentifier)((DataNormalizationOperation)this).getIdentifier()).getNodeType().equals((Object)child)) {
                return this.innerOp;
            }
            return null;
        }
    }

    private static final class OrderedLeafListMixinNormalization
    extends UnorderedLeafListMixinNormalization {
        OrderedLeafListMixinNormalization(LeafListSchemaNode potential) {
            super(potential);
        }

        @Override
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return Builders.orderedLeafSetBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)((DataNormalizationOperation)this).getIdentifier()).build();
        }
    }

    private static abstract class MixinNormalizationOp<T extends YangInstanceIdentifier.PathArgument>
    extends CompositeNodeNormalizationOperation<T> {
        protected MixinNormalizationOp(T identifier, DataSchemaNode schema) {
            super(identifier, schema);
        }

        @Override
        public final boolean isMixin() {
            return true;
        }
    }

    private static final class ContainerNormalization
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.NodeIdentifier> {
        protected ContainerNormalization(ContainerSchemaNode schema) {
            super(new YangInstanceIdentifier.NodeIdentifier(schema.getQName()), (DataNodeContainer)schema, (DataSchemaNode)schema);
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeIdentifier)currentArg)).build();
        }
    }

    private static final class UnkeyedListItemNormalization
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.NodeIdentifier> {
        protected UnkeyedListItemNormalization(ListSchemaNode schema) {
            super(new YangInstanceIdentifier.NodeIdentifier(schema.getQName()), (DataNodeContainer)schema, (DataSchemaNode)schema);
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return Builders.unkeyedListEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeIdentifier)currentArg)).build();
        }
    }

    private static final class ListItemNormalization
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.NodeIdentifierWithPredicates> {
        protected ListItemNormalization(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, ListSchemaNode schema) {
            super(identifier, (DataNodeContainer)schema, (DataSchemaNode)schema);
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            DataContainerNodeAttrBuilder builder = Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeIdentifierWithPredicates)currentArg));
            for (Map.Entry keyValue : ((YangInstanceIdentifier.NodeIdentifierWithPredicates)currentArg).getKeyValues().entrySet()) {
                builder.addChild(Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier((QName)keyValue.getKey())).withValue(keyValue.getValue()).build());
            }
            return builder.build();
        }

        @Override
        public boolean isKeyedEntry() {
            return true;
        }
    }

    private static abstract class DataContainerNormalizationOperation<T extends YangInstanceIdentifier.PathArgument>
    extends CompositeNodeNormalizationOperation<T> {
        private final DataNodeContainer schema;
        private final Map<QName, DataNormalizationOperation<?>> byQName;
        private final Map<YangInstanceIdentifier.PathArgument, DataNormalizationOperation<?>> byArg;

        protected DataContainerNormalizationOperation(T identifier, DataNodeContainer schema, DataSchemaNode node) {
            super(identifier, node);
            this.schema = schema;
            this.byArg = new ConcurrentHashMap();
            this.byQName = new ConcurrentHashMap();
        }

        @Override
        public DataNormalizationOperation<?> getChild(YangInstanceIdentifier.PathArgument child) throws DataNormalizationException {
            DataNormalizationOperation<?> potential = this.byArg.get(child);
            if (potential != null) {
                return potential;
            }
            potential = this.fromLocalSchema(child);
            return this.register(potential);
        }

        @Override
        public DataNormalizationOperation<?> getChild(QName child) throws DataNormalizationException {
            DataNormalizationOperation<?> potential = this.byQName.get(child);
            if (potential != null) {
                return potential;
            }
            potential = this.fromLocalSchemaAndQName(this.schema, child);
            return this.register(potential);
        }

        private DataNormalizationOperation<?> fromLocalSchema(YangInstanceIdentifier.PathArgument child) throws DataNormalizationException {
            if (child instanceof YangInstanceIdentifier.AugmentationIdentifier) {
                return DataNormalizationOperation.fromSchemaAndQNameChecked(this.schema, (QName)((YangInstanceIdentifier.AugmentationIdentifier)child).getPossibleChildNames().iterator().next());
            }
            return DataNormalizationOperation.fromSchemaAndQNameChecked(this.schema, child.getNodeType());
        }

        protected DataNormalizationOperation<?> fromLocalSchemaAndQName(DataNodeContainer schema2, QName child) throws DataNormalizationException {
            return DataNormalizationOperation.fromSchemaAndQNameChecked(schema2, child);
        }

        private DataNormalizationOperation<?> register(DataNormalizationOperation<?> potential) {
            if (potential != null) {
                this.byArg.put((YangInstanceIdentifier.PathArgument)potential.getIdentifier(), potential);
                for (QName qname : potential.getQNameIdentifiers()) {
                    this.byQName.put(qname, potential);
                }
            }
            return potential;
        }
    }

    private static abstract class CompositeNodeNormalizationOperation<T extends YangInstanceIdentifier.PathArgument>
    extends DataNormalizationOperation<T> {
        protected CompositeNodeNormalizationOperation(T identifier, DataSchemaNode schema) {
            super(identifier, (SchemaNode)schema);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }

    private static final class LeafListEntryNormalization
    extends SimpleTypeNormalization<YangInstanceIdentifier.NodeWithValue> {
        LeafListEntryNormalization(LeafListSchemaNode potential) {
            super(new YangInstanceIdentifier.NodeWithValue(potential.getQName(), null), (DataSchemaNode)potential);
        }

        @Override
        public boolean isKeyedEntry() {
            return true;
        }
    }

    private static final class LeafNormalization
    extends SimpleTypeNormalization<YangInstanceIdentifier.NodeIdentifier> {
        protected LeafNormalization(LeafSchemaNode potential) {
            super(new YangInstanceIdentifier.NodeIdentifier(potential.getQName()), (DataSchemaNode)potential);
        }
    }

    private static abstract class SimpleTypeNormalization<T extends YangInstanceIdentifier.PathArgument>
    extends DataNormalizationOperation<T> {
        protected SimpleTypeNormalization(T identifier, DataSchemaNode potential) {
            super(identifier, (SchemaNode)potential);
        }

        @Override
        public DataNormalizationOperation<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return null;
        }

        @Override
        public DataNormalizationOperation<?> getChild(QName child) {
            return null;
        }

        @Override
        public NormalizedNode<?, ?> createDefault(YangInstanceIdentifier.PathArgument currentArg) {
            return null;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }
    }
}

