/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.gen.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.AbstractGenerator;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.DataObjectSerializerSource;
import org.opendaylight.mdsal.binding.dom.codec.util.BindingSchemaMapping;
import org.opendaylight.mdsal.binding.dom.codec.util.ChoiceDispatchSerializer;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.binding.BindingSerializer;
import org.opendaylight.yangtools.yang.binding.BindingStreamEventWriter;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializerImplementation;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializerRegistry;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DataNodeContainerSerializerSource
extends DataObjectSerializerSource {
    private static final Logger LOG = LoggerFactory.getLogger(DataNodeContainerSerializerSource.class);
    protected static final String INPUT = "_input";
    private static final String CHOICE_PREFIX = "CHOICE_";
    protected final DataNodeContainer schemaNode;
    private final GeneratedType dtoType;

    DataNodeContainerSerializerSource(AbstractGenerator generator, GeneratedType type, DataNodeContainer node) {
        super(generator);
        this.dtoType = Objects.requireNonNull(type);
        this.schemaNode = Objects.requireNonNull(node);
    }

    protected abstract CharSequence emitStartEvent();

    @Override
    protected CharSequence getSerializerBody() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.assign(DataObjectSerializerRegistry.class.getName(), "_registry", (CharSequence)"$1")));
        sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.assign(this.dtoType.getFullyQualifiedName(), INPUT, DataNodeContainerSerializerSource.cast(this.dtoType.getFullyQualifiedName(), (CharSequence)"$2"))));
        sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.assign(BindingStreamEventWriter.class.getName(), "_stream", DataNodeContainerSerializerSource.cast(BindingStreamEventWriter.class.getName(), (CharSequence)"$3"))));
        sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.assign(BindingSerializer.class.getName(), "_serializer", null)));
        sb.append("if (");
        sb.append("_stream");
        sb.append(" instanceof ");
        sb.append(BindingSerializer.class.getName());
        sb.append(") {");
        sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.assign("_serializer", DataNodeContainerSerializerSource.cast(BindingSerializer.class.getName(), (CharSequence)"_stream"))));
        sb.append('}');
        sb.append(DataNodeContainerSerializerSource.statement(this.emitStartEvent()));
        this.emitBody(sb);
        this.emitAfterBody(sb);
        sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.endNode()));
        sb.append(DataNodeContainerSerializerSource.statement("return null"));
        sb.append('}');
        return sb;
    }

    protected void emitAfterBody(StringBuilder sb) {
    }

    private static Map<String, Type> collectAllProperties(GeneratedType type, Map<String, Type> hashMap) {
        for (MethodSignature definition : type.getMethodDefinitions()) {
            hashMap.put(definition.getName(), definition.getReturnType());
        }
        for (Type parent : type.getImplements()) {
            if (!(parent instanceof GeneratedType)) continue;
            DataNodeContainerSerializerSource.collectAllProperties((GeneratedType)parent, hashMap);
        }
        return hashMap;
    }

    private void emitBody(StringBuilder sb) {
        Map<String, Type> getterToType = DataNodeContainerSerializerSource.collectAllProperties(this.dtoType, new HashMap<String, Type>());
        for (DataSchemaNode schemaChild : this.schemaNode.getChildNodes()) {
            if (schemaChild.isAugmenting()) continue;
            String getter = BindingSchemaMapping.getGetterMethodName(schemaChild);
            Type childType = getterToType.get(getter);
            if (childType == null) {
                if (schemaChild instanceof AnyXmlSchemaNode) {
                    LOG.warn("Node {} will be ignored. AnyXml is not yet supported from binding aware code.Binding Independent code can be used to serialize anyXml nodes.", (Object)schemaChild.getPath());
                    continue;
                }
                throw new IllegalStateException(String.format("Unable to find type for child node %s. Expected child nodes: %s", schemaChild.getPath(), getterToType));
            }
            this.emitChild(sb, getter, childType, schemaChild);
        }
    }

    private void emitChild(StringBuilder sb, String getterName, Type childType, DataSchemaNode schemaChild) {
        sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.assign(childType, getterName, DataNodeContainerSerializerSource.cast(childType, DataNodeContainerSerializerSource.invoke((CharSequence)INPUT, getterName, new Object[0])))));
        sb.append("if (").append(getterName).append(" != null) {\n");
        this.emitChildInner(sb, getterName, childType, schemaChild);
        sb.append("}\n");
    }

    private void emitChildInner(StringBuilder sb, String getterName, Type childType, DataSchemaNode child) {
        if (child instanceof LeafSchemaNode) {
            sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.leafNode(child.getQName().getLocalName(), getterName)));
        } else if (child instanceof AnyXmlSchemaNode) {
            sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.anyxmlNode(child.getQName().getLocalName(), getterName)));
        } else if (child instanceof LeafListSchemaNode) {
            CharSequence startEvent = ((LeafListSchemaNode)child).isUserOrdered() ? DataNodeContainerSerializerSource.startOrderedLeafSet(child.getQName().getLocalName(), DataNodeContainerSerializerSource.invoke((CharSequence)getterName, "size", new Object[0])) : DataNodeContainerSerializerSource.startLeafSet(child.getQName().getLocalName(), DataNodeContainerSerializerSource.invoke((CharSequence)getterName, "size", new Object[0]));
            sb.append(DataNodeContainerSerializerSource.statement(startEvent));
            Type valueType = ((ParameterizedType)childType).getActualTypeArguments()[0];
            sb.append(DataNodeContainerSerializerSource.forEach(getterName, valueType, DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.leafSetEntryNode("_current"))));
            sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.endNode()));
        } else if (child instanceof ListSchemaNode) {
            Type valueType = ((ParameterizedType)childType).getActualTypeArguments()[0];
            ListSchemaNode casted = (ListSchemaNode)child;
            this.emitList(sb, getterName, valueType, casted);
        } else if (child instanceof ContainerSchemaNode) {
            sb.append((CharSequence)DataNodeContainerSerializerSource.tryToUseCacheElse(getterName, DataNodeContainerSerializerSource.statement(this.staticInvokeEmitter(childType, getterName))));
        } else if (child instanceof ChoiceSchemaNode) {
            String propertyName = CHOICE_PREFIX + childType.getName();
            this.staticConstant(propertyName, DataObjectSerializerImplementation.class, ChoiceDispatchSerializer.from(this.loadClass(childType)));
            sb.append((CharSequence)DataNodeContainerSerializerSource.tryToUseCacheElse(getterName, DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.invoke((CharSequence)propertyName, "serialize", "_registry", DataNodeContainerSerializerSource.cast(DataObject.class.getName(), (CharSequence)getterName), "_stream"))));
        }
    }

    private static StringBuilder tryToUseCacheElse(String getterName, CharSequence statement) {
        return new StringBuilder().append("if (").append("_serializer").append(" == null || ").append(DataNodeContainerSerializerSource.invoke((CharSequence)"_serializer", "serialize", (Object)getterName)).append(" == null) {\n").append(statement).append('}');
    }

    private void emitList(StringBuilder sb, String getterName, Type valueType, ListSchemaNode child) {
        sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.assign("int", "_count", DataNodeContainerSerializerSource.invoke((CharSequence)getterName, "size", new Object[0]))));
        CharSequence startEvent = child.getKeyDefinition().isEmpty() ? DataNodeContainerSerializerSource.startUnkeyedList(DataNodeContainerSerializerSource.classReference(valueType), "_count") : (child.isUserOrdered() ? DataNodeContainerSerializerSource.startOrderedMapNode(DataNodeContainerSerializerSource.classReference(valueType), "_count") : DataNodeContainerSerializerSource.startMapNode(DataNodeContainerSerializerSource.classReference(valueType), "_count"));
        sb.append(DataNodeContainerSerializerSource.statement(startEvent));
        sb.append(DataNodeContainerSerializerSource.forEach(getterName, valueType, DataNodeContainerSerializerSource.tryToUseCacheElse("_current", DataNodeContainerSerializerSource.statement(this.staticInvokeEmitter(valueType, "_current")))));
        sb.append(DataNodeContainerSerializerSource.statement(DataNodeContainerSerializerSource.endNode()));
    }
}

