/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.gen.impl;

import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.AbstractGenerator;
import org.opendaylight.mdsal.binding.dom.codec.gen.spi.AbstractSource;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.GeneratedClassLoadingStrategy;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.binding.DataContainer;

abstract class DataObjectSerializerSource
extends AbstractSource {
    private static final ClassLoadingStrategy STRATEGY = GeneratedClassLoadingStrategy.getTCCLClassLoadingStrategy();
    protected static final String SERIALIZER = "_serializer";
    protected static final String STREAM = "_stream";
    protected static final String ITERATOR = "_iterator";
    protected static final String CURRENT = "_current";
    protected static final String REGISTRY = "_registry";
    private final AbstractGenerator generator;

    DataObjectSerializerSource(AbstractGenerator generator) {
        this.generator = Objects.requireNonNull(generator);
    }

    protected Class<? extends DataContainer> loadClass(Type childType) {
        try {
            return STRATEGY.loadClass(childType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load referenced class ", e);
        }
    }

    protected abstract CharSequence getSerializerBody();

    protected static final CharSequence leafNode(String localName, CharSequence value) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "leafNode", DataObjectSerializerSource.escape(localName), value);
    }

    protected static final CharSequence startLeafSet(String localName, CharSequence expected) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startLeafSet", DataObjectSerializerSource.escape(localName), expected);
    }

    protected static final CharSequence startOrderedLeafSet(String localName, CharSequence expected) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startOrderedLeafSet", DataObjectSerializerSource.escape(localName), expected);
    }

    protected static final CharSequence leafSetEntryNode(CharSequence value) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "leafSetEntryNode", (Object)value);
    }

    protected static final CharSequence startContainerNode(CharSequence type, CharSequence expected) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startContainerNode", type, expected);
    }

    protected static final CharSequence escape(String localName) {
        return '\"' + localName + '\"';
    }

    protected static final CharSequence startUnkeyedList(CharSequence type, CharSequence expected) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startUnkeyedList", type, expected);
    }

    protected static final CharSequence startUnkeyedListItem(CharSequence expected) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startUnkeyedListItem", (Object)expected);
    }

    protected static final CharSequence startMapNode(CharSequence type, CharSequence expected) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startMapNode", type, expected);
    }

    protected static final CharSequence startOrderedMapNode(CharSequence type, CharSequence expected) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startOrderedMapNode", type, expected);
    }

    protected static final CharSequence startMapEntryNode(CharSequence key, CharSequence expected) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startMapEntryNode", key, expected);
    }

    protected static final CharSequence startAugmentationNode(CharSequence key) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startAugmentationNode", (Object)key);
    }

    protected static final CharSequence startChoiceNode(CharSequence localName, CharSequence expected) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startChoiceNode", localName, expected);
    }

    protected static final CharSequence startCaseNode(CharSequence localName, CharSequence expected) {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "startCase", localName, expected);
    }

    protected static final CharSequence anyxmlNode(String name, String value) throws IllegalArgumentException {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "anyxmlNode", DataObjectSerializerSource.escape(name), name);
    }

    protected static final CharSequence endNode() {
        return DataObjectSerializerSource.invoke((CharSequence)STREAM, "endNode", new Object[0]);
    }

    protected static final CharSequence forEach(String iterable, Type valueType, CharSequence body) {
        return DataObjectSerializerSource.forEach(iterable, ITERATOR, valueType.getFullyQualifiedName(), CURRENT, body);
    }

    protected static final CharSequence classReference(Type type) {
        return type.getFullyQualifiedName() + ".class";
    }

    protected final CharSequence staticInvokeEmitter(Type childType, String name) {
        Class cls;
        try {
            cls = STRATEGY.loadClass(childType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to invoke emitter", e);
        }
        String className = this.generator.loadSerializerFor(cls) + ".getInstance()";
        return DataObjectSerializerSource.invoke((CharSequence)className, "serialize", REGISTRY, name, STREAM);
    }
}

