/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCache;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.yangtools.yang.binding.DataObject;

abstract class AbstractBindingNormalizedNodeCacheHolder {
    private final ImmutableSet<Class<? extends DataObject>> cachedValues;
    private final LoadingCache<DataContainerCodecContext<?, ?>, BindingNormalizedNodeCache> caches = CacheBuilder.newBuilder().build(new CacheLoader<DataContainerCodecContext<?, ?>, BindingNormalizedNodeCache>(){

        public BindingNormalizedNodeCache load(DataContainerCodecContext<?, ?> key) {
            return new BindingNormalizedNodeCache(AbstractBindingNormalizedNodeCacheHolder.this, key);
        }
    });

    AbstractBindingNormalizedNodeCacheHolder(ImmutableSet<Class<? extends DataObject>> cacheSpec) {
        this.cachedValues = Objects.requireNonNull(cacheSpec);
    }

    BindingNormalizedNodeCache getCachingSerializer(DataContainerCodecContext<?, ?> childCtx) {
        if (this.isCached(childCtx.getBindingClass())) {
            return (BindingNormalizedNodeCache)((Object)this.caches.getUnchecked(childCtx));
        }
        return null;
    }

    boolean isCached(Class<?> type) {
        return this.cachedValues.contains(type);
    }
}

