/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.ActionCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.dom.codec.impl.CaseNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentifiableItemCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentityCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.InstanceIdentifierCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NotificationCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.RpcInputCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.SchemaRootCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.UnionTypeCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueTypeCodec;
import org.opendaylight.mdsal.binding.dom.codec.util.BindingSchemaMapping;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.BindingStreamEventWriter;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializer;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BindingCodecContext
implements NodeCodecContext.CodecContextFactory,
BindingCodecTree,
Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(BindingCodecContext.class);
    private final InstanceIdentifierCodec instanceIdentifierCodec;
    private final IdentityCodec identityCodec;
    private final BindingNormalizedNodeCodecRegistry registry;
    private final BindingRuntimeContext context;
    private final SchemaRootCodecContext<?> root;

    BindingCodecContext(BindingRuntimeContext context, BindingNormalizedNodeCodecRegistry registry) {
        this.context = Objects.requireNonNull(context, "Binding Runtime Context is required.");
        this.root = SchemaRootCodecContext.create(this);
        this.identityCodec = new IdentityCodec(context);
        this.instanceIdentifierCodec = new InstanceIdentifierCodec(this);
        this.registry = Objects.requireNonNull(registry);
    }

    @Override
    public BindingRuntimeContext getRuntimeContext() {
        return this.context;
    }

    InstanceIdentifierCodec getInstanceIdentifierCodec() {
        return this.instanceIdentifierCodec;
    }

    IdentityCodec getIdentityCodec() {
        return this.identityCodec;
    }

    @Override
    public DataObjectSerializer getEventStreamSerializer(Class<?> type) {
        return this.registry.getSerializer(type);
    }

    public Map.Entry<YangInstanceIdentifier, BindingStreamEventWriter> newWriter(InstanceIdentifier<?> path, NormalizedNodeStreamWriter domWriter) {
        LinkedList<YangInstanceIdentifier.PathArgument> yangArgs = new LinkedList<YangInstanceIdentifier.PathArgument>();
        DataContainerCodecContext<?, ?> codecContext = this.getCodecContextNode(path, yangArgs);
        return new AbstractMap.SimpleEntry<YangInstanceIdentifier, BindingStreamEventWriter>(YangInstanceIdentifier.create(yangArgs), codecContext.createWriter(domWriter));
    }

    public BindingStreamEventWriter newWriterWithoutIdentifier(InstanceIdentifier<?> path, NormalizedNodeStreamWriter domWriter) {
        return this.getCodecContextNode(path, null).createWriter(domWriter);
    }

    BindingStreamEventWriter newRpcWriter(Class<? extends DataContainer> rpcInputOrOutput, NormalizedNodeStreamWriter domWriter) {
        return this.root.getRpc(rpcInputOrOutput).createWriter(domWriter);
    }

    BindingStreamEventWriter newNotificationWriter(Class<? extends Notification> notification, NormalizedNodeStreamWriter domWriter) {
        return this.root.getNotification(notification).createWriter(domWriter);
    }

    public DataContainerCodecContext<?, ?> getCodecContextNode(InstanceIdentifier<?> binding, List<YangInstanceIdentifier.PathArgument> builder) {
        BindingCodecTreeNode<Object> currentNode = this.root;
        for (InstanceIdentifier.PathArgument bindingArg : binding.getPathArguments()) {
            Preconditions.checkArgument(((currentNode = ((DataContainerCodecContext)currentNode).bindingPathArgumentChild(bindingArg, (List)builder)) != null ? 1 : 0) != 0, (String)"Supplied Instance Identifier %s is not valid.", binding);
        }
        return currentNode;
    }

    @Nullable NodeCodecContext<?> getCodecContextNode(@NonNull YangInstanceIdentifier dom, @Nullable Collection<// Could not load outer class - annotation placement on inner may be incorrect
    InstanceIdentifier.PathArgument> bindingArguments) {
        BindingCodecTreeNode<Object> currentNode = this.root;
        DataContainerCodecContext currentList = null;
        for (YangInstanceIdentifier.PathArgument domArg : dom.getPathArguments()) {
            Preconditions.checkArgument((boolean)(currentNode instanceof DataContainerCodecContext), (String)"Unexpected child of non-container node %s", currentNode);
            DataContainerCodecContext previous = currentNode;
            BindingCodecTreeNode nextNode = previous.yangPathArgumentChild(domArg);
            if (currentList != null) {
                Preconditions.checkArgument((currentList == nextNode ? 1 : 0) != 0, (String)"List should be referenced two times in YANG Instance Identifier %s", (Object)dom);
                if (bindingArguments != null) {
                    bindingArguments.add(currentList.getBindingPathArgument(domArg));
                }
                currentList = null;
                currentNode = nextNode;
                continue;
            }
            if (nextNode instanceof ListNodeCodecContext) {
                currentList = (ListNodeCodecContext)nextNode;
                continue;
            }
            if (nextNode instanceof ChoiceNodeCodecContext) {
                currentNode = nextNode;
                continue;
            }
            if (nextNode instanceof DataContainerCodecContext) {
                if (bindingArguments != null) {
                    bindingArguments.add(((DataContainerCodecContext)nextNode).getBindingPathArgument(domArg));
                }
                currentNode = nextNode;
                continue;
            }
            if (!(nextNode instanceof LeafNodeCodecContext)) continue;
            LOG.debug("Instance identifier referencing a leaf is not representable ({})", (Object)dom);
            return null;
        }
        if (currentNode instanceof ChoiceNodeCodecContext) {
            LOG.debug("Instance identifier targeting a choice is not representable ({})", (Object)dom);
            return null;
        }
        if (currentNode instanceof CaseNodeCodecContext) {
            LOG.debug("Instance identifier targeting a case is not representable ({})", (Object)dom);
            return null;
        }
        if (currentList != null) {
            if (bindingArguments != null) {
                bindingArguments.add(currentList.getBindingPathArgument(null));
            }
            return currentList;
        }
        return currentNode;
    }

    NotificationCodecContext<?> getNotificationContext(SchemaPath notification) {
        return this.root.getNotification(notification);
    }

    RpcInputCodec<?> getRpcInputCodec(SchemaPath path) {
        return this.root.getRpc(path);
    }

    ActionCodecContext getActionCodec(Class<? extends Action<?, ?, ?>> action) {
        return this.root.getAction(action);
    }

    @Override
    public ImmutableMap<String, LeafNodeCodecContext<?>> getLeafNodes(Class<?> parentClass, DataNodeContainer childSchema) {
        HashMap<String, DataSchemaNode> getterToLeafSchema = new HashMap<String, DataSchemaNode>();
        for (DataSchemaNode leaf : childSchema.getChildNodes()) {
            if (!(leaf instanceof TypedDataSchemaNode)) continue;
            getterToLeafSchema.put(BindingSchemaMapping.getGetterMethodName((TypedDataSchemaNode)leaf), leaf);
        }
        return this.getLeafNodesUsingReflection(parentClass, getterToLeafSchema);
    }

    private ImmutableMap<String, LeafNodeCodecContext<?>> getLeafNodesUsingReflection(Class<?> parentClass, Map<String, DataSchemaNode> getterToLeafSchema) {
        HashMap leaves = new HashMap();
        for (Method method : parentClass.getMethods()) {
            Class valueType;
            if (method.getParameterCount() != 0) continue;
            DataSchemaNode schema = getterToLeafSchema.get(method.getName());
            if (schema instanceof LeafSchemaNode) {
                valueType = method.getReturnType();
            } else {
                if (!(schema instanceof LeafListSchemaNode)) continue;
                Type genericType = ClassLoaderUtils.getFirstGenericParameter((Type)method.getGenericReturnType());
                if (genericType instanceof Class) {
                    valueType = (Class)genericType;
                } else if (genericType instanceof ParameterizedType) {
                    valueType = (Class)((ParameterizedType)genericType).getRawType();
                } else {
                    throw new IllegalStateException("Unexpected return type " + genericType);
                }
            }
            Codec<Object, Object> codec = this.getCodec(valueType, schema);
            LeafNodeCodecContext leafNode = new LeafNodeCodecContext(schema, codec, method, this.context.getSchemaContext());
            leaves.put(schema.getQName().getLocalName(), leafNode);
        }
        return ImmutableMap.copyOf(leaves);
    }

    private Codec<Object, Object> getCodec(Class<?> valueType, DataSchemaNode schema) {
        Preconditions.checkArgument((boolean)(schema instanceof TypedDataSchemaNode), (String)"Unsupported leaf node type %s", (Object)schema);
        return this.getCodec(valueType, ((TypedDataSchemaNode)schema).getType());
    }

    Codec<Object, Object> getCodec(Class<?> valueType, TypeDefinition<?> instantiatedType) {
        if (Class.class.equals(valueType)) {
            IdentityCodec casted = this.identityCodec;
            return casted;
        }
        if (InstanceIdentifier.class.equals(valueType)) {
            InstanceIdentifierCodec casted = this.instanceIdentifierCodec;
            return casted;
        }
        if (Boolean.class.equals(valueType)) {
            if (instantiatedType instanceof EmptyTypeDefinition) {
                return ValueTypeCodec.EMPTY_CODEC;
            }
        } else if (BindingReflections.isBindingClass(valueType)) {
            return this.getCodecForBindingClass(valueType, instantiatedType);
        }
        return ValueTypeCodec.NOOP_CODEC;
    }

    private Codec<Object, Object> getCodecForBindingClass(Class<?> valueType, TypeDefinition<?> typeDef) {
        if (typeDef instanceof IdentityrefTypeDefinition) {
            return ValueTypeCodec.encapsulatedValueCodecFor(valueType, typeDef, this.identityCodec);
        }
        if (typeDef instanceof InstanceIdentifierTypeDefinition) {
            return ValueTypeCodec.encapsulatedValueCodecFor(valueType, typeDef, this.instanceIdentifierCodec);
        }
        if (typeDef instanceof UnionTypeDefinition) {
            Callable<UnionTypeCodec> loader = UnionTypeCodec.loader(valueType, (UnionTypeDefinition)typeDef, this);
            try {
                return loader.call();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load codec for " + valueType, e);
            }
        }
        if (typeDef instanceof LeafrefTypeDefinition) {
            Map.Entry typeWithSchema = this.context.getTypeWithSchema(valueType);
            DocumentedNode.WithStatus schema = (DocumentedNode.WithStatus)typeWithSchema.getValue();
            Preconditions.checkState((boolean)(schema instanceof TypeDefinition));
            return this.getCodec(valueType, (TypeDefinition)schema);
        }
        return ValueTypeCodec.getCodecFor(valueType, typeDef);
    }

    @Override
    public IdentifiableItemCodec getPathArgumentCodec(Class<?> listClz, ListSchemaNode schema) {
        Class identifier = ClassLoaderUtils.findFirstGenericArgument(listClz, Identifiable.class);
        HashMap<QName, ValueContext> valueCtx = new HashMap<QName, ValueContext>();
        for (LeafNodeCodecContext leaf : this.getLeafNodes(identifier, (DataNodeContainer)schema).values()) {
            QName name = leaf.getDomPathArgument().getNodeType();
            valueCtx.put(name, new ValueContext(identifier, leaf));
        }
        return IdentifiableItemCodec.of(schema, identifier, listClz, valueCtx);
    }

    @Override
    public <T extends DataObject> BindingCodecTreeNode<T> getSubtreeCodec(InstanceIdentifier<T> path) {
        return this.getCodecContextNode(path, null);
    }

    @Override
    public BindingCodecTreeNode<?> getSubtreeCodec(YangInstanceIdentifier path) {
        return this.getCodecContextNode(path, null);
    }

    @Override
    public BindingCodecTreeNode<?> getSubtreeCodec(SchemaPath path) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

