/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.io.IOException;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractBindingNormalizedNodeCacheHolder;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCache;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingToNormalizedStreamWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ForwardingBindingStreamEventWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.NormalizedNodeWriterWithAddChild;
import org.opendaylight.yangtools.yang.binding.BindingSerializer;
import org.opendaylight.yangtools.yang.binding.BindingStreamEventWriter;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;

final class CachingNormalizedNodeSerializer
extends ForwardingBindingStreamEventWriter
implements BindingSerializer<Object, DataObject> {
    private final NormalizedNodeResult domResult;
    private final NormalizedNodeWriterWithAddChild domWriter;
    private final BindingToNormalizedStreamWriter delegate;
    private final AbstractBindingNormalizedNodeCacheHolder cacheHolder;

    CachingNormalizedNodeSerializer(AbstractBindingNormalizedNodeCacheHolder cacheHolder, DataContainerCodecContext<?, ?> subtreeRoot) {
        this.cacheHolder = cacheHolder;
        this.domResult = new NormalizedNodeResult();
        this.domWriter = new NormalizedNodeWriterWithAddChild(this.domResult);
        this.delegate = BindingToNormalizedStreamWriter.create(subtreeRoot, (NormalizedNodeStreamWriter)this.domWriter);
    }

    @Override
    protected BindingStreamEventWriter delegate() {
        return this.delegate;
    }

    NormalizedNode<?, ?> build() {
        return this.domResult.getResult();
    }

    public NormalizedNode<?, ?> serialize(DataObject input) {
        BindingNormalizedNodeCache cachingSerializer = this.getCacheSerializer(input.getImplementedInterface());
        if (cachingSerializer != null) {
            NormalizedNode<?, ?> domData = cachingSerializer.get(input);
            this.domWriter.addChild(domData);
            return domData;
        }
        return null;
    }

    static NormalizedNode<?, ?> serialize(AbstractBindingNormalizedNodeCacheHolder cacheHolder, DataContainerCodecContext<?, ?> subtreeRoot, DataObject data) {
        BindingNormalizedNodeCache cache = cacheHolder.getCachingSerializer(subtreeRoot);
        if (cache != null) {
            return cache.get(data);
        }
        return CachingNormalizedNodeSerializer.serializeUsingStreamWriter(cacheHolder, subtreeRoot, data);
    }

    private BindingNormalizedNodeCache getCacheSerializer(Class type) {
        if (this.cacheHolder.isCached(type)) {
            DataContainerCodecContext currentCtx = (DataContainerCodecContext)this.delegate.current();
            if (type.equals(currentCtx.getBindingClass())) {
                return this.cacheHolder.getCachingSerializer(currentCtx);
            }
            return this.cacheHolder.getCachingSerializer((DataContainerCodecContext<?, ?>)currentCtx.streamChild(type));
        }
        return null;
    }

    static NormalizedNode<?, ?> serializeUsingStreamWriter(AbstractBindingNormalizedNodeCacheHolder cacheHolder, DataContainerCodecContext<?, ?> subtreeRoot, DataObject data) {
        CachingNormalizedNodeSerializer writer = new CachingNormalizedNodeSerializer(cacheHolder, subtreeRoot);
        try {
            subtreeRoot.eventStreamSerializer().serialize(data, (BindingStreamEventWriter)writer);
            return writer.build();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

