/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCachingCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingToNormalizedStreamWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.CachingNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.IncorrectNestingException;
import org.opendaylight.mdsal.binding.dom.codec.impl.MissingClassInLoadingStrategyException;
import org.opendaylight.mdsal.binding.dom.codec.impl.MissingSchemaException;
import org.opendaylight.mdsal.binding.dom.codec.impl.MissingSchemaForClassException;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NonCachingCodec;
import org.opendaylight.yangtools.yang.binding.BindingStreamEventWriter;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializer;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;

abstract class DataContainerCodecContext<D extends DataObject, T extends DocumentedNode.WithStatus>
extends NodeCodecContext<D> {
    private final DataContainerCodecPrototype<T> prototype;
    private volatile DataObjectSerializer eventStreamSerializer;

    protected DataContainerCodecContext(DataContainerCodecPrototype<T> prototype) {
        this.prototype = prototype;
    }

    public final T getSchema() {
        return this.prototype.getSchema();
    }

    @Override
    public final BindingCodecTreeNode.ChildAddressabilitySummary getChildAddressabilitySummary() {
        return this.prototype.getChildAddressabilitySummary();
    }

    protected final QNameModule namespace() {
        return this.prototype.getNamespace();
    }

    protected final NodeCodecContext.CodecContextFactory factory() {
        return this.prototype.getFactory();
    }

    @Override
    protected YangInstanceIdentifier.PathArgument getDomPathArgument() {
        return this.prototype.getYangArg();
    }

    @Override
    public abstract NodeCodecContext<?> yangPathArgumentChild(YangInstanceIdentifier.PathArgument var1);

    public DataContainerCodecContext<?, ?> bindingPathArgumentChild(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        BindingCodecTreeNode child = this.streamChild(arg.getType());
        if (builder != null) {
            ((NodeCodecContext)child).addYangPathArgument(arg, builder);
        }
        return child;
    }

    protected InstanceIdentifier.PathArgument getBindingPathArgument(YangInstanceIdentifier.PathArgument domArg) {
        return this.bindingArg();
    }

    protected final InstanceIdentifier.PathArgument bindingArg() {
        return this.prototype.getBindingArg();
    }

    @Override
    public final Class<D> getBindingClass() {
        return (Class)Class.class.cast(this.prototype.getBindingClass());
    }

    public abstract <C extends DataObject> DataContainerCodecContext<C, ?> streamChild(Class<C> var1);

    @Override
    public abstract <C extends DataObject> Optional<DataContainerCodecContext<C, ?>> possibleStreamChild(Class<C> var1);

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.prototype.getBindingClass() + "]";
    }

    @Override
    public BindingNormalizedNodeCachingCodec<D> createCachingCodec(ImmutableCollection<Class<? extends DataObject>> cacheSpecifier) {
        if (cacheSpecifier.isEmpty()) {
            return new NonCachingCodec(this);
        }
        return new CachingNormalizedNodeCodec(this, (ImmutableSet<Class<? extends DataObject>>)ImmutableSet.copyOf(cacheSpecifier));
    }

    BindingStreamEventWriter createWriter(NormalizedNodeStreamWriter domWriter) {
        return BindingToNormalizedStreamWriter.create(this, domWriter);
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, YangInstanceIdentifier.PathArgument child, String message, Object ... args) {
        if (nullable != null) {
            return nullable;
        }
        MissingSchemaException.checkModulePresent(this.factory().getRuntimeContext().getSchemaContext(), child);
        throw IncorrectNestingException.create(message, args);
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, QName child, String message, Object ... args) {
        if (nullable != null) {
            return nullable;
        }
        MissingSchemaException.checkModulePresent(this.factory().getRuntimeContext().getSchemaContext(), child);
        throw IncorrectNestingException.create(message, args);
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, Class<?> childClass, String message, Object ... args) {
        if (nullable != null) {
            return nullable;
        }
        MissingSchemaForClassException.check(this.factory().getRuntimeContext(), childClass);
        MissingClassInLoadingStrategyException.check(this.factory().getRuntimeContext().getStrategy(), childClass);
        throw IncorrectNestingException.create(message, args);
    }

    DataObjectSerializer eventStreamSerializer() {
        if (this.eventStreamSerializer == null) {
            this.eventStreamSerializer = this.factory().getEventStreamSerializer(this.getBindingClass());
        }
        return this.eventStreamSerializer;
    }

    @Override
    public NormalizedNode<?, ?> serialize(D data) {
        NormalizedNodeResult result = new NormalizedNodeResult();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
        this.writeAsNormalizedNode(data, domWriter);
        return result.getResult();
    }

    @Override
    public void writeAsNormalizedNode(D data, NormalizedNodeStreamWriter writer) {
        try {
            this.eventStreamSerializer().serialize(data, this.createWriter(writer));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize Binding DTO", e);
        }
    }
}

