/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.Iterables;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentationNodeContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CaseNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ContainerNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.KeyedListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeContextSupplier;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.AnyDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataContainerCodecPrototype<T extends DocumentedNode.WithStatus>
implements NodeContextSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(DataContainerCodecPrototype.class);
    private final T schema;
    private final QNameModule namespace;
    private final NodeCodecContext.CodecContextFactory factory;
    private final InstanceIdentifier.Item<?> bindingArg;
    private final YangInstanceIdentifier.PathArgument yangArg;
    private final BindingCodecTreeNode.ChildAddressabilitySummary childAddressabilitySummary;
    private volatile DataContainerCodecContext<?, T> instance = null;

    private DataContainerCodecPrototype(Class<?> cls, YangInstanceIdentifier.PathArgument arg, T nodeSchema, NodeCodecContext.CodecContextFactory factory) {
        this(InstanceIdentifier.Item.of(cls), arg, nodeSchema, factory);
    }

    private DataContainerCodecPrototype(InstanceIdentifier.Item<?> bindingArg, YangInstanceIdentifier.PathArgument arg, T nodeSchema, NodeCodecContext.CodecContextFactory factory) {
        this.bindingArg = bindingArg;
        this.yangArg = arg;
        this.schema = nodeSchema;
        this.factory = factory;
        this.namespace = arg instanceof YangInstanceIdentifier.AugmentationIdentifier ? ((QName)Iterables.getFirst((Iterable)((YangInstanceIdentifier.AugmentationIdentifier)arg).getPossibleChildNames(), null)).getModule() : arg.getNodeType().getModule();
        this.childAddressabilitySummary = DataContainerCodecPrototype.computeChildAddressabilitySummary(nodeSchema);
    }

    private static BindingCodecTreeNode.ChildAddressabilitySummary computeChildAddressabilitySummary(DocumentedNode.WithStatus nodeSchema) {
        if (nodeSchema instanceof DataNodeContainer) {
            boolean haveAddressable = false;
            boolean haveUnaddressable = false;
            block10: for (DataSchemaNode child : ((DataNodeContainer)nodeSchema).getChildNodes()) {
                if (child instanceof ContainerSchemaNode || child instanceof AugmentationSchemaNode) {
                    haveAddressable = true;
                    continue;
                }
                if (child instanceof ListSchemaNode) {
                    if (((ListSchemaNode)child).getKeyDefinition().isEmpty()) {
                        haveUnaddressable = true;
                        continue;
                    }
                    haveAddressable = true;
                    continue;
                }
                if (child instanceof AnyDataSchemaNode || child instanceof AnyXmlSchemaNode || child instanceof TypedDataSchemaNode) {
                    haveUnaddressable = true;
                    continue;
                }
                if (child instanceof ChoiceSchemaNode) {
                    switch (DataContainerCodecPrototype.computeChildAddressabilitySummary((DocumentedNode.WithStatus)child)) {
                        case ADDRESSABLE: {
                            haveAddressable = true;
                            continue block10;
                        }
                        case MIXED: {
                            haveAddressable = true;
                            haveUnaddressable = true;
                            continue block10;
                        }
                        case UNADDRESSABLE: {
                            haveUnaddressable = true;
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Unhandled accessibility summary for " + child);
                }
                LOG.warn("Unhandled child node {}", (Object)child);
            }
            if (!haveAddressable) {
                return BindingCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
            }
            return haveUnaddressable ? BindingCodecTreeNode.ChildAddressabilitySummary.MIXED : BindingCodecTreeNode.ChildAddressabilitySummary.ADDRESSABLE;
        }
        if (nodeSchema instanceof ChoiceSchemaNode) {
            boolean haveAddressable = false;
            boolean haveUnaddressable = false;
            block11: for (CaseSchemaNode child : ((ChoiceSchemaNode)nodeSchema).getCases().values()) {
                switch (DataContainerCodecPrototype.computeChildAddressabilitySummary((DocumentedNode.WithStatus)child)) {
                    case ADDRESSABLE: {
                        haveAddressable = true;
                        continue block11;
                    }
                    case UNADDRESSABLE: {
                        haveUnaddressable = true;
                        continue block11;
                    }
                    case MIXED: {
                        return BindingCodecTreeNode.ChildAddressabilitySummary.MIXED;
                    }
                }
                throw new IllegalStateException("Unhandled accessibility summary for " + child);
            }
            if (!haveAddressable) {
                return BindingCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
            }
            return haveUnaddressable ? BindingCodecTreeNode.ChildAddressabilitySummary.MIXED : BindingCodecTreeNode.ChildAddressabilitySummary.ADDRESSABLE;
        }
        return BindingCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
    }

    static DataContainerCodecPrototype<SchemaContext> rootPrototype(NodeCodecContext.CodecContextFactory factory) {
        SchemaContext schema = factory.getRuntimeContext().getSchemaContext();
        YangInstanceIdentifier.NodeIdentifier arg = YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName());
        return new DataContainerCodecPrototype<SchemaContext>(DataRoot.class, (YangInstanceIdentifier.PathArgument)arg, schema, factory);
    }

    static <T extends DataSchemaNode> DataContainerCodecPrototype<T> from(Class<?> cls, T schema, NodeCodecContext.CodecContextFactory factory) {
        return new DataContainerCodecPrototype<T>(cls, (YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), schema, factory);
    }

    static <T extends DataSchemaNode> DataContainerCodecPrototype<T> from(InstanceIdentifier.Item<?> bindingArg, T schema, NodeCodecContext.CodecContextFactory factory) {
        return new DataContainerCodecPrototype<T>(bindingArg, (YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), schema, factory);
    }

    static DataContainerCodecPrototype<?> from(Class<?> augClass, YangInstanceIdentifier.AugmentationIdentifier arg, AugmentationSchemaNode schema, NodeCodecContext.CodecContextFactory factory) {
        return new DataContainerCodecPrototype<AugmentationSchemaNode>(augClass, (YangInstanceIdentifier.PathArgument)arg, schema, factory);
    }

    static DataContainerCodecPrototype<NotificationDefinition> from(Class<?> augClass, NotificationDefinition schema, NodeCodecContext.CodecContextFactory factory) {
        YangInstanceIdentifier.NodeIdentifier arg = YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName());
        return new DataContainerCodecPrototype<NotificationDefinition>(augClass, (YangInstanceIdentifier.PathArgument)arg, schema, factory);
    }

    protected T getSchema() {
        return this.schema;
    }

    BindingCodecTreeNode.ChildAddressabilitySummary getChildAddressabilitySummary() {
        return this.childAddressabilitySummary;
    }

    protected QNameModule getNamespace() {
        return this.namespace;
    }

    protected NodeCodecContext.CodecContextFactory getFactory() {
        return this.factory;
    }

    protected Class<?> getBindingClass() {
        return this.bindingArg.getType();
    }

    protected InstanceIdentifier.Item<?> getBindingArg() {
        return this.bindingArg;
    }

    protected YangInstanceIdentifier.PathArgument getYangArg() {
        return this.yangArg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataContainerCodecContext<?, T> get() {
        DataContainerCodecContext<?, T> tmp = this.instance;
        if (tmp == null) {
            DataContainerCodecPrototype dataContainerCodecPrototype = this;
            synchronized (dataContainerCodecPrototype) {
                tmp = this.instance;
                if (tmp == null) {
                    this.instance = tmp = this.createInstance();
                }
            }
        }
        return tmp;
    }

    @GuardedBy(value="this")
    private DataContainerCodecContext<?, T> createInstance() {
        if (this.schema instanceof ContainerSchemaNode) {
            return new ContainerNodeCodecContext(this);
        }
        if (this.schema instanceof ListSchemaNode) {
            return Identifiable.class.isAssignableFrom(this.getBindingClass()) ? new KeyedListNodeCodecContext(this) : new ListNodeCodecContext(this);
        }
        if (this.schema instanceof ChoiceSchemaNode) {
            return new ChoiceNodeCodecContext(this);
        }
        if (this.schema instanceof AugmentationSchemaNode) {
            return new AugmentationNodeContext(this);
        }
        if (this.schema instanceof CaseSchemaNode) {
            return new CaseNodeCodecContext(this);
        }
        throw new IllegalArgumentException("Unsupported type " + this.getBindingClass() + " " + this.schema);
    }

    boolean isChoice() {
        return this.schema instanceof ChoiceSchemaNode;
    }
}

