/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.util.List;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentifiableItemCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListNodeCodecContext;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

final class KeyedListNodeCodecContext<D extends DataObject & Identifiable<?>>
extends ListNodeCodecContext<D> {
    private final IdentifiableItemCodec codec;

    KeyedListNodeCodecContext(DataContainerCodecPrototype<ListSchemaNode> prototype) {
        super(prototype);
        Class bindingClass = this.getBindingClass();
        this.codec = this.factory().getPathArgumentCodec(bindingClass, (ListSchemaNode)this.getSchema());
        try {
            bindingClass.getMethod("key", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Required method not available", e);
        }
    }

    @Override
    protected void addYangPathArgument(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        if (builder == null) {
            return;
        }
        super.addYangPathArgument(arg, builder);
        if (arg instanceof InstanceIdentifier.IdentifiableItem) {
            builder.add((YangInstanceIdentifier.PathArgument)this.codec.serialize((InstanceIdentifier.IdentifiableItem)arg));
        } else {
            super.addYangPathArgument(arg, builder);
        }
    }

    @Override
    Object getBindingChildValue(String methodName, NormalizedNodeContainer dom) {
        if (dom instanceof MapEntryNode && "key".equals(methodName)) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates identifier = ((MapEntryNode)dom).getIdentifier();
            return this.codec.deserialize(identifier).getKey();
        }
        return super.getBindingChildValue(methodName, dom);
    }

    @Override
    protected InstanceIdentifier.PathArgument getBindingPathArgument(YangInstanceIdentifier.PathArgument domArg) {
        if (domArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            return this.codec.deserialize((YangInstanceIdentifier.NodeIdentifierWithPredicates)domArg);
        }
        return super.getBindingPathArgument(domArg);
    }

    YangInstanceIdentifier.NodeIdentifierWithPredicates serialize(Identifier<?> key) {
        return this.codec.serialize(InstanceIdentifier.IdentifiableItem.of(this.getBindingClass(), key));
    }

    @Override
    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        if (arg instanceof InstanceIdentifier.IdentifiableItem) {
            return this.codec.serialize((InstanceIdentifier.IdentifiableItem)arg);
        }
        return super.serializePathArgument(arg);
    }

    @Override
    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            return this.codec.deserialize((YangInstanceIdentifier.NodeIdentifierWithPredicates)arg);
        }
        return super.deserializePathArgument(arg);
    }
}

