/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.util.AugmentationReader;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LazyDataObject<D extends DataObject>
implements InvocationHandler,
AugmentationReader {
    private static final Logger LOG = LoggerFactory.getLogger(LazyDataObject.class);
    private static final String TO_STRING = "toString";
    private static final String EQUALS = "equals";
    private static final String HASHCODE = "hashCode";
    private static final String AUGMENTATIONS = "augmentations";
    private static final @NonNull Object NULL_VALUE = new Object();
    private final ConcurrentHashMap<String, Object> cachedData = new ConcurrentHashMap();
    private final NormalizedNodeContainer<?, YangInstanceIdentifier.PathArgument, NormalizedNode<?, ?>> data;
    private final DataObjectCodecContext<D, ?> context;
    private static final AtomicReferenceFieldUpdater<LazyDataObject, ImmutableMap> CACHED_AUGMENTATIONS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LazyDataObject.class, ImmutableMap.class, "cachedAugmentations");
    private volatile ImmutableMap<Class<? extends Augmentation<?>>, Augmentation<?>> cachedAugmentations = null;
    private volatile Integer cachedHashcode = null;

    LazyDataObject(DataObjectCodecContext<D, ?> ctx, NormalizedNodeContainer data) {
        this.context = Objects.requireNonNull(ctx, "Context must not be null");
        this.data = Objects.requireNonNull(data, "Data must not be null");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        switch (method.getParameterCount()) {
            case 0: {
                String methodName;
                switch (methodName = method.getName()) {
                    case "getImplementedInterface": {
                        return this.context.getBindingClass();
                    }
                    case "toString": {
                        return this.bindingToString();
                    }
                    case "hashCode": {
                        return this.bindingHashCode();
                    }
                    case "augmentations": {
                        return this.getAugmentationsImpl();
                    }
                }
                return method.isDefault() ? this.nonnullBindingData(methodName) : this.getBindingData(methodName);
            }
            case 1: {
                switch (method.getName()) {
                    case "augmentation": {
                        return this.getAugmentationImpl((Class)args[0]);
                    }
                    case "equals": {
                        return this.bindingEquals(args[0]);
                    }
                }
                break;
            }
        }
        throw new UnsupportedOperationException("Unsupported method " + method);
    }

    private boolean bindingEquals(Object other) {
        if (other == null) {
            return false;
        }
        Class bindingClass = this.context.getBindingClass();
        if (!bindingClass.isAssignableFrom(other.getClass())) {
            return false;
        }
        try {
            for (Method m : this.context.propertyMethods()) {
                Object thisValue = this.getBindingData(m.getName());
                Object otherValue = m.invoke(other, new Object[0]);
                if (!(thisValue instanceof byte[] && otherValue instanceof byte[] ? !Arrays.equals((byte[])thisValue, (byte[])otherValue) : !Objects.equals(thisValue, otherValue))) continue;
                return false;
            }
            if (Augmentable.class.isAssignableFrom(bindingClass) && !this.getAugmentationsImpl().equals(LazyDataObject.getAllAugmentations(other))) {
                return false;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOG.warn("Can not determine equality of {} and {}", new Object[]{this, other, e});
            return false;
        }
        return true;
    }

    private static Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAllAugmentations(Object dataObject) {
        if (dataObject instanceof AugmentationReader) {
            return ((AugmentationReader)dataObject).getAugmentations(dataObject);
        }
        if (dataObject instanceof Augmentable) {
            return BindingReflections.getAugmentations((Augmentable)((Augmentable)dataObject));
        }
        throw new IllegalArgumentException("Unable to get all augmentations from " + dataObject);
    }

    private Integer bindingHashCode() {
        Integer ret;
        Integer cached = this.cachedHashcode;
        if (cached != null) {
            return cached;
        }
        int prime = 31;
        int result = 1;
        for (Method m : this.context.propertyMethods()) {
            Object value = this.getBindingData(m.getName());
            result = 31 * result + Objects.hashCode(value);
        }
        if (Augmentable.class.isAssignableFrom(this.context.getBindingClass())) {
            result = 31 * result + this.getAugmentationsImpl().hashCode();
        }
        this.cachedHashcode = ret = Integer.valueOf(result);
        return ret;
    }

    private Object nonnullBindingData(String methodName) {
        Object value = this.getBindingData(this.context.getterNameForNonnullName(methodName));
        return value != null ? value : ImmutableList.of();
    }

    private Object getBindingData(String methodName) {
        Object cached = this.cachedData.get(methodName);
        if (cached != null) {
            return LazyDataObject.unmaskNull(cached);
        }
        Object value = this.context.getBindingChildValue(methodName, this.data);
        Object raced = this.cachedData.putIfAbsent(methodName, value == null ? NULL_VALUE : value);
        return raced != null ? LazyDataObject.unmaskNull(raced) : value;
    }

    private static Object unmaskNull(@NonNull Object masked) {
        return masked == NULL_VALUE ? null : masked;
    }

    private Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAugmentationsImpl() {
        ImmutableMap<Class<? extends Augmentation<?>>, Augmentation<?>> local = this.cachedAugmentations;
        if (local != null) {
            return local;
        }
        local = ImmutableMap.copyOf(this.context.getAllAugmentationsFrom(this.data));
        return CACHED_AUGMENTATIONS_UPDATER.compareAndSet(this, null, (ImmutableMap)local) ? local : this.cachedAugmentations;
    }

    @Override
    public Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAugmentations(Object obj) {
        Preconditions.checkArgument((this == Proxy.getInvocationHandler(obj) ? 1 : 0) != 0, (Object)"Supplied object is not associated with this proxy handler");
        return this.getAugmentationsImpl();
    }

    private Object getAugmentationImpl(Class<?> cls) {
        Optional augData;
        DataContainerCodecContext<?, ?> augCtx;
        Objects.requireNonNull(cls, "Supplied augmentation must not be null.");
        ImmutableMap<Class<? extends Augmentation<?>>, Augmentation<?>> aug = this.cachedAugmentations;
        if (aug != null) {
            return aug.get(cls);
        }
        Optional<DataContainerCodecContext<?, ?>> optAugCtx = this.context.possibleStreamChild(cls);
        if (optAugCtx.isPresent() && cls.isAssignableFrom((augCtx = optAugCtx.get()).getBindingClass()) && (augData = this.data.getChild(augCtx.getDomPathArgument())).isPresent()) {
            return augCtx.deserialize((NormalizedNode)augData.get());
        }
        return null;
    }

    public String bindingToString() {
        Class bindingClass = this.context.getBindingClass();
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(bindingClass).omitNullValues();
        for (Method m : this.context.propertyMethods()) {
            String methodName = m.getName();
            helper.add(methodName, this.getBindingData(methodName));
        }
        if (Augmentable.class.isAssignableFrom(bindingClass)) {
            helper.add(AUGMENTATIONS, this.getAugmentationsImpl());
        }
        return helper.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.context.hashCode();
        result = 31 * result + this.data.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LazyDataObject other = (LazyDataObject)obj;
        return Objects.equals(this.context, other.context) && Objects.equals(this.data, other.data);
    }
}

