/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import org.opendaylight.mdsal.binding.dom.codec.impl.MissingSchemaException;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;

public class MissingClassInLoadingStrategyException
extends MissingSchemaException {
    private static final long serialVersionUID = 1L;

    protected MissingClassInLoadingStrategyException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public static void check(ClassLoadingStrategy strategy, Class<?> childClass) {
        try {
            strategy.loadClass(childClass.getName());
        }
        catch (ClassNotFoundException e) {
            String message = String.format("User supplied class %s is not available in %s.", childClass.getName(), strategy);
            throw new MissingClassInLoadingStrategyException(message, e);
        }
    }
}

