/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class MissingSchemaException
extends IllegalArgumentException {
    private static final long serialVersionUID = 1L;

    protected MissingSchemaException(String msg) {
        super(msg);
    }

    protected MissingSchemaException(String msg, Throwable cause) {
        super(msg, cause);
    }

    private static MissingSchemaException create(String format, Object ... args) {
        return new MissingSchemaException(String.format(format, args));
    }

    static void checkModulePresent(SchemaContext schemaContext, QName name) {
        if (!schemaContext.findModule(name.getModule()).isPresent()) {
            throw MissingSchemaException.create("Module %s is not present in current schema context.", name.getModule());
        }
    }

    static void checkModulePresent(SchemaContext schemaContext, YangInstanceIdentifier.PathArgument child) {
        MissingSchemaException.checkModulePresent(schemaContext, MissingSchemaException.extractName(child));
    }

    private static QName extractName(YangInstanceIdentifier.PathArgument child) {
        if (child instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            Set children = ((YangInstanceIdentifier.AugmentationIdentifier)child).getPossibleChildNames();
            Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0, (Object)"Augmentation without childs must not be used in data");
            return (QName)children.iterator().next();
        }
        return child.getNodeType();
    }
}

