/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.impl.MissingSchemaException;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public final class MissingSchemaForClassException
extends MissingSchemaException {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient Class<?> bindingClass;

    private MissingSchemaForClassException(Class<?> clz) {
        super(String.format("Schema is not available for %s", clz));
        this.bindingClass = Objects.requireNonNull(clz);
    }

    static MissingSchemaForClassException forClass(Class<?> clz) {
        return new MissingSchemaForClassException(clz);
    }

    public Class<?> getBindingClass() {
        return this.bindingClass;
    }

    public static void check(BindingRuntimeContext runtimeContext, Class<?> bindingClass) {
        Object schema = Augmentation.class.isAssignableFrom(bindingClass) ? runtimeContext.getAugmentationDefinition(bindingClass) : runtimeContext.getSchemaDefinition(bindingClass);
        if (schema == null) {
            throw MissingSchemaForClassException.forClass(bindingClass);
        }
    }
}

