/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.dom.codec.impl.BitsCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.CompositeValueCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.EncapsulatedValueCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.EnumerationCodec;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

abstract class ValueTypeCodec
implements Codec<Object, Object> {
    private static final Cache<Class<?>, SchemaUnawareCodec> STATIC_CODECS = CacheBuilder.newBuilder().weakKeys().build();
    public static final SchemaUnawareCodec NOOP_CODEC = new SchemaUnawareCodec(){

        public Object serialize(Object input) {
            return input;
        }

        public Object deserialize(Object input) {
            return input;
        }
    };
    public static final SchemaUnawareCodec EMPTY_CODEC = new SchemaUnawareCodec(){

        public Object serialize(Object input) {
            return Empty.getInstance();
        }

        public Object deserialize(Object input) {
            return Boolean.TRUE;
        }
    };
    private static final Callable<? extends SchemaUnawareCodec> EMPTY_LOADER = () -> EMPTY_CODEC;

    ValueTypeCodec() {
    }

    public static SchemaUnawareCodec getCodecFor(Class<?> typeClz, TypeDefinition<?> def) {
        if (BindingReflections.isBindingClass(typeClz)) {
            return ValueTypeCodec.getCachedSchemaUnawareCodec(typeClz, ValueTypeCodec.getCodecLoader(typeClz, def));
        }
        return def instanceof EmptyTypeDefinition ? EMPTY_CODEC : NOOP_CODEC;
    }

    private static SchemaUnawareCodec getCachedSchemaUnawareCodec(Class<?> typeClz, Callable<? extends SchemaUnawareCodec> loader) {
        try {
            return (SchemaUnawareCodec)STATIC_CODECS.get(typeClz, loader);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Callable<? extends SchemaUnawareCodec> getCodecLoader(Class<?> typeClz, TypeDefinition<?> def) {
        TypeDefinition rootType = def;
        while (rootType.getBaseType() != null) {
            rootType = rootType.getBaseType();
        }
        if (rootType instanceof EnumTypeDefinition) {
            return EnumerationCodec.loader(typeClz, (EnumTypeDefinition)rootType);
        }
        if (rootType instanceof BitsTypeDefinition) {
            return BitsCodec.loader(typeClz, (BitsTypeDefinition)rootType);
        }
        return EncapsulatedValueCodec.loader(typeClz, def);
    }

    static ValueTypeCodec encapsulatedValueCodecFor(Class<?> typeClz, TypeDefinition<?> typeDef, Codec delegate) {
        SchemaUnawareCodec extractor = ValueTypeCodec.getCachedSchemaUnawareCodec(typeClz, EncapsulatedValueCodec.loader(typeClz, typeDef));
        return new CompositeValueCodec(extractor, delegate);
    }

    static interface SchemaUnawareCodec
    extends Codec<Object, Object> {
    }
}

