/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.mdsal.binding.dom.codec.util.AugmentationReader;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BindingStreamEventWriter;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializer;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializerImplementation;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AugmentableDispatchSerializer
implements DataObjectSerializerImplementation {
    private static final Logger LOG = LoggerFactory.getLogger(AugmentableDispatchSerializer.class);

    public void serialize(DataObjectSerializerRegistry reg, DataObject obj, BindingStreamEventWriter stream) throws IOException {
        if (obj instanceof Augmentable) {
            Map<Class<Object>, Object> augmentations = reg instanceof AugmentationReader ? ((AugmentationReader)reg).getAugmentations(obj) : (Proxy.isProxyClass(obj.getClass()) ? AugmentableDispatchSerializer.getFromProxy(obj) : BindingReflections.getAugmentations((Augmentable)((Augmentable)obj)));
            for (Map.Entry<Class<Augmentation<?>>, Augmentation<?>> aug : augmentations.entrySet()) {
                AugmentableDispatchSerializer.emitAugmentation(aug.getKey(), aug.getValue(), stream, reg);
            }
        }
    }

    private static Map<Class<? extends Augmentation<?>>, Augmentation<?>> getFromProxy(DataObject obj) {
        InvocationHandler proxy = Proxy.getInvocationHandler(obj);
        if (proxy instanceof AugmentationReader) {
            return ((AugmentationReader)((Object)proxy)).getAugmentations(obj);
        }
        return Collections.emptyMap();
    }

    private static void emitAugmentation(Class type, Augmentation<?> value, BindingStreamEventWriter stream, DataObjectSerializerRegistry registry) throws IOException {
        if (value == null) {
            return;
        }
        Preconditions.checkArgument((boolean)(value instanceof DataObject));
        DataObjectSerializer serializer = registry.getSerializer(type);
        if (serializer != null) {
            serializer.serialize((DataObject)value, stream);
        } else {
            LOG.warn("DataObjectSerializer is not present for {} in registry {}", (Object)type, (Object)registry);
        }
    }
}

