/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.util;

import java.io.IOException;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.BindingStreamEventWriter;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializer;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializerImplementation;
import org.opendaylight.yangtools.yang.binding.DataObjectSerializerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChoiceDispatchSerializer
implements DataObjectSerializerImplementation {
    private static final Logger LOG = LoggerFactory.getLogger(ChoiceDispatchSerializer.class);
    private final Class choiceClass;

    private ChoiceDispatchSerializer(Class choiceClass) {
        this.choiceClass = Objects.requireNonNull(choiceClass);
    }

    public static ChoiceDispatchSerializer from(Class<? extends DataContainer> choiceClass) {
        return new ChoiceDispatchSerializer(choiceClass);
    }

    public void serialize(DataObjectSerializerRegistry reg, DataObject obj, BindingStreamEventWriter stream) throws IOException {
        Class cazeClass = obj.getImplementedInterface();
        stream.startChoiceNode(this.choiceClass, -1);
        DataObjectSerializer caseSerializer = reg.getSerializer(cazeClass);
        if (caseSerializer != null) {
            caseSerializer.serialize(obj, stream);
        } else {
            LOG.warn("No serializer for case {} is available in registry {}", (Object)cazeClass, (Object)reg);
        }
        stream.endNode();
    }
}

