/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class Ipv6FlowLabel
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -7589288865525379836L;
    private final Long _value;

    private static void check_valueRange(long value) {
        if (value >= 0L && value <= 1048575L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..1048575]]", (long)value);
    }

    @ConstructorProperties(value={"value"})
    public Ipv6FlowLabel(Long _value) {
        if (_value != null) {
            Ipv6FlowLabel.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public Ipv6FlowLabel(Ipv6FlowLabel source) {
        this._value = source._value;
    }

    public static Ipv6FlowLabel getDefaultInstance(String defaultValue) {
        return new Ipv6FlowLabel(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ipv6FlowLabel other = (Ipv6FlowLabel)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Ipv6FlowLabel.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

