/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.tcp;

import io.netty.channel.ChannelFuture;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.opendaylight.netconf.api.NetconfServerDispatcher;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfNorthboundTcpServer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfNorthboundTcpServer.class);
    private final ChannelFuture tcpServer;

    public NetconfNorthboundTcpServer(NetconfServerDispatcher netconfServerDispatcher, String address, String port) {
        InetSocketAddress inetAddress = NetconfNorthboundTcpServer.getInetAddress(address, port);
        this.tcpServer = netconfServerDispatcher.createServer(inetAddress);
        this.tcpServer.addListener(future -> {
            if (!future.isDone() || !future.isSuccess()) {
                LOG.warn("Unable to start TCP netconf server at {}", (Object)inetAddress, (Object)future.cause());
                throw new RuntimeException("Unable to start TCP netconf server", future.cause());
            }
            LOG.info("Netconf TCP endpoint started successfully at {}", (Object)inetAddress);
        });
    }

    private static InetSocketAddress getInetAddress(String bindingAddress, String portNumber) {
        IpAddress ipAddress = IpAddressBuilder.getDefaultInstance((String)bindingAddress);
        InetAddress inetAd = IetfInetUtil.INSTANCE.inetAddressFor((Object)ipAddress);
        return new InetSocketAddress(inetAd, Integer.parseInt(portNumber));
    }

    @Override
    public void close() {
        if (this.tcpServer.isDone()) {
            this.tcpServer.channel().close();
        } else {
            this.tcpServer.cancel(true);
        }
    }
}

