/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.view.rev131030.aggregate.node;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.view.rev131030.aggregate.node.OriginalNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OriginalNodeBuilder
implements Builder<OriginalNode> {
    private NodeId _node;
    private TopologyId _topology;
    Map<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>> augmentation = Collections.emptyMap();

    public OriginalNodeBuilder() {
    }

    public OriginalNodeBuilder(OriginalNode base) {
        Map aug;
        this._node = base.getNode();
        this._topology = base.getTopology();
        if (base instanceof OriginalNodeImpl) {
            OriginalNodeImpl impl = (OriginalNodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>>(aug);
        }
    }

    public NodeId getNode() {
        return this._node;
    }

    public TopologyId getTopology() {
        return this._topology;
    }

    public <E$$ extends Augmentation<OriginalNode>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public OriginalNodeBuilder setNode(NodeId value) {
        this._node = value;
        return this;
    }

    public OriginalNodeBuilder setTopology(TopologyId value) {
        this._topology = value;
        return this;
    }

    public OriginalNodeBuilder addAugmentation(Class<? extends Augmentation<OriginalNode>> augmentationType, Augmentation<OriginalNode> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OriginalNodeBuilder removeAugmentation(Class<? extends Augmentation<OriginalNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OriginalNode build() {
        return new OriginalNodeImpl(this);
    }

    private static final class OriginalNodeImpl
    implements OriginalNode {
        private final NodeId _node;
        private final TopologyId _topology;
        private Map<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        OriginalNodeImpl(OriginalNodeBuilder base) {
            this._node = base.getNode();
            this._topology = base.getTopology();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<OriginalNode> getImplementedInterface() {
            return OriginalNode.class;
        }

        @Override
        public NodeId getNode() {
            return this._node;
        }

        @Override
        public TopologyId getTopology() {
            return this._topology;
        }

        public <E$$ extends Augmentation<OriginalNode>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._topology);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OriginalNode.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OriginalNode other = (OriginalNode)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._topology, other.getTopology())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OriginalNodeImpl otherImpl = (OriginalNodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"OriginalNode");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_node", (Object)this._node);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_topology", (Object)this._topology);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

