/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.collect.ImmutableMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.AbstractMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

class ChoiceNodeContextNode
extends AbstractMixinContextNode<YangInstanceIdentifier.NodeIdentifier> {
    private final ImmutableMap<QName, DataSchemaContextNode<?>> byQName;
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, DataSchemaContextNode<?>> byArg;

    protected ChoiceNodeContextNode(ChoiceSchemaNode schema) {
        super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), (DataSchemaNode)schema);
        ImmutableMap.Builder byQNameBuilder = ImmutableMap.builder();
        ImmutableMap.Builder byArgBuilder = ImmutableMap.builder();
        for (CaseSchemaNode caze : schema.getCases().values()) {
            for (DataSchemaNode cazeChild : caze.getChildNodes()) {
                DataSchemaContextNode<?> childOp = ChoiceNodeContextNode.fromDataSchemaNode(cazeChild);
                byArgBuilder.put(childOp.getIdentifier(), childOp);
                for (QName qname : childOp.getQNameIdentifiers()) {
                    byQNameBuilder.put((Object)qname, childOp);
                }
            }
        }
        this.byQName = byQNameBuilder.build();
        this.byArg = byArgBuilder.build();
    }

    @Override
    public DataSchemaContextNode<?> getChild(YangInstanceIdentifier.PathArgument child) {
        return (DataSchemaContextNode)this.byArg.get((Object)child);
    }

    @Override
    public DataSchemaContextNode<?> getChild(QName child) {
        return (DataSchemaContextNode)this.byQName.get((Object)child);
    }
}

