/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.opendaylight.yangtools.odlext.model.api.YangModeledAnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.CaseNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ChoiceNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ContainerNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.LeafListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.YangModeledAnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class CompositeNodeDataWithSchema
extends AbstractNodeDataWithSchema {
    private final Multimap<AugmentationSchemaNode, AbstractNodeDataWithSchema> augmentationsToChild = ArrayListMultimap.create();
    private final List<AbstractNodeDataWithSchema> children = new ArrayList<AbstractNodeDataWithSchema>();

    public CompositeNodeDataWithSchema(DataSchemaNode schema) {
        super(schema);
    }

    private AbstractNodeDataWithSchema addChild(DataSchemaNode schema) {
        AbstractNodeDataWithSchema newChild = this.addSimpleChild(schema);
        return newChild == null ? this.addCompositeChild(schema) : newChild;
    }

    public void addChild(AbstractNodeDataWithSchema newChild) {
        this.children.add(newChild);
    }

    public AbstractNodeDataWithSchema addChild(Deque<DataSchemaNode> schemas) {
        Collection<AbstractNodeDataWithSchema> childNodes;
        CompositeNodeDataWithSchema caseNodeDataWithSchema;
        Preconditions.checkArgument((!schemas.isEmpty() ? 1 : 0) != 0, (Object)"Expecting at least one schema");
        DataSchemaNode schema = schemas.pop();
        if (schemas.isEmpty()) {
            return this.addChild(schema);
        }
        DataSchemaNode choiceCandidate = schema;
        Preconditions.checkArgument((boolean)(choiceCandidate instanceof ChoiceSchemaNode), (String)"Expected node of type ChoiceNode but was %s", (Object)choiceCandidate.getClass().getSimpleName());
        ChoiceSchemaNode choiceNode = (ChoiceSchemaNode)choiceCandidate;
        DataSchemaNode caseCandidate = schemas.pop();
        Preconditions.checkArgument((boolean)(caseCandidate instanceof CaseSchemaNode), (String)"Expected node of type ChoiceCaseNode but was %s", (Object)caseCandidate.getClass().getSimpleName());
        CaseSchemaNode caseNode = (CaseSchemaNode)caseCandidate;
        AugmentationSchemaNode augSchema = null;
        if (choiceCandidate.isAugmenting()) {
            augSchema = CompositeNodeDataWithSchema.findCorrespondingAugment(this.getSchema(), choiceCandidate);
        }
        if ((caseNodeDataWithSchema = CompositeNodeDataWithSchema.findChoice(childNodes = augSchema != null ? this.augmentationsToChild.get((Object)augSchema) : this.children, choiceCandidate, caseCandidate)) == null) {
            ChoiceNodeDataWithSchema choiceNodeDataWithSchema = new ChoiceNodeDataWithSchema(choiceNode);
            childNodes.add(choiceNodeDataWithSchema);
            caseNodeDataWithSchema = choiceNodeDataWithSchema.addCompositeChild((DataSchemaNode)caseNode);
        }
        return caseNodeDataWithSchema.addChild(schemas);
    }

    private AbstractNodeDataWithSchema addSimpleChild(DataSchemaNode schema) {
        SimpleNodeDataWithSchema newChild = null;
        if (schema instanceof LeafSchemaNode) {
            newChild = new LeafNodeDataWithSchema(schema);
        } else if (schema instanceof AnyXmlSchemaNode) {
            if (schema instanceof YangModeledAnyXmlSchemaNode) {
                return null;
            }
            newChild = new AnyXmlNodeDataWithSchema(schema);
        } else {
            return null;
        }
        AugmentationSchemaNode augSchema = null;
        if (schema.isAugmenting()) {
            augSchema = CompositeNodeDataWithSchema.findCorrespondingAugment(this.getSchema(), schema);
        }
        if (augSchema != null) {
            this.augmentationsToChild.put((Object)augSchema, (Object)newChild);
        } else {
            this.addChild(newChild);
        }
        return newChild;
    }

    private static CaseNodeDataWithSchema findChoice(Collection<AbstractNodeDataWithSchema> childNodes, DataSchemaNode choiceCandidate, DataSchemaNode caseCandidate) {
        if (childNodes != null) {
            for (AbstractNodeDataWithSchema nodeDataWithSchema : childNodes) {
                if (!(nodeDataWithSchema instanceof ChoiceNodeDataWithSchema) || !nodeDataWithSchema.getSchema().getQName().equals((Object)choiceCandidate.getQName())) continue;
                CaseNodeDataWithSchema casePrevious = ((ChoiceNodeDataWithSchema)nodeDataWithSchema).getCase();
                Preconditions.checkArgument((boolean)casePrevious.getSchema().getQName().equals((Object)caseCandidate.getQName()), (String)"Data from case %s are specified but other data from case %s were specified earlier. Data aren't from the same case.", (Object)caseCandidate.getQName(), (Object)casePrevious.getSchema().getQName());
                return casePrevious;
            }
        }
        return null;
    }

    AbstractNodeDataWithSchema addCompositeChild(DataSchemaNode schema) {
        CompositeNodeDataWithSchema newChild = schema instanceof ListSchemaNode ? new ListNodeDataWithSchema(schema) : (schema instanceof LeafListSchemaNode ? new LeafListNodeDataWithSchema(schema) : (schema instanceof ContainerSchemaNode ? new ContainerNodeDataWithSchema(schema) : (schema instanceof YangModeledAnyXmlSchemaNode ? new YangModeledAnyXmlNodeDataWithSchema((YangModeledAnyXmlSchemaNode)schema) : new CompositeNodeDataWithSchema(schema))));
        this.addCompositeChild(newChild);
        return newChild;
    }

    void addCompositeChild(CompositeNodeDataWithSchema newChild) {
        AugmentationSchemaNode augSchema = CompositeNodeDataWithSchema.findCorrespondingAugment(this.getSchema(), newChild.getSchema());
        if (augSchema != null) {
            this.augmentationsToChild.put((Object)augSchema, (Object)newChild);
        } else {
            this.addChild(newChild);
        }
    }

    protected final int childSizeHint() {
        return this.children.size();
    }

    @Override
    public void write(NormalizedNodeStreamWriter writer) throws IOException {
        for (AbstractNodeDataWithSchema abstractNodeDataWithSchema : this.children) {
            abstractNodeDataWithSchema.write(writer);
        }
        for (Map.Entry entry : this.augmentationsToChild.asMap().entrySet()) {
            Collection childsFromAgumentation = (Collection)entry.getValue();
            if (childsFromAgumentation.isEmpty()) continue;
            writer.startAugmentationNode(DataSchemaContextNode.augmentationIdentifierFrom((AugmentationSchemaNode)entry.getKey()));
            for (AbstractNodeDataWithSchema nodeDataWithSchema : childsFromAgumentation) {
                nodeDataWithSchema.write(writer);
            }
            writer.endNode();
        }
    }

    private static AugmentationSchemaNode findCorrespondingAugment(DataSchemaNode parent, DataSchemaNode child) {
        if (parent instanceof AugmentationTarget && !(parent instanceof ChoiceSchemaNode)) {
            for (AugmentationSchemaNode augmentation : ((AugmentationTarget)parent).getAvailableAugmentations()) {
                DataSchemaNode childInAugmentation = augmentation.getDataChildByName(child.getQName());
                if (childInAugmentation == null) continue;
                return augmentation;
            }
        }
        return null;
    }

    @Deprecated
    public static YangInstanceIdentifier.AugmentationIdentifier getNodeIdentifierForAugmentation(AugmentationSchemaNode schema) {
        return DataSchemaContextNode.augmentationIdentifierFrom(schema);
    }
}

