/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeUpdatedBuilder
implements Builder<NodeUpdated> {
    private NodeId _id;
    private List<NodeConnector> _nodeConnector;
    private NodeRef _nodeRef;
    Map<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>> augmentation = Collections.emptyMap();

    public NodeUpdatedBuilder() {
    }

    public NodeUpdatedBuilder(Node arg) {
        this._id = arg.getId();
        this._nodeConnector = arg.getNodeConnector();
    }

    public NodeUpdatedBuilder(NodeUpdated base) {
        Map aug;
        this._id = base.getId();
        this._nodeConnector = base.getNodeConnector();
        this._nodeRef = base.getNodeRef();
        if (base instanceof NodeUpdatedImpl) {
            NodeUpdatedImpl impl = (NodeUpdatedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Node) {
            this._id = ((Node)arg).getId();
            this._nodeConnector = ((Node)arg).getNodeConnector();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node]");
    }

    public NodeId getId() {
        return this._id;
    }

    public List<NodeConnector> getNodeConnector() {
        return this._nodeConnector;
    }

    public NodeRef getNodeRef() {
        return this._nodeRef;
    }

    public <E$$ extends Augmentation<NodeUpdated>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NodeUpdatedBuilder setId(NodeId value) {
        this._id = value;
        return this;
    }

    public NodeUpdatedBuilder setNodeConnector(List<NodeConnector> values) {
        this._nodeConnector = values;
        return this;
    }

    public NodeUpdatedBuilder setNodeRef(NodeRef value) {
        this._nodeRef = value;
        return this;
    }

    public NodeUpdatedBuilder addAugmentation(Class<? extends Augmentation<NodeUpdated>> augmentationType, Augmentation<NodeUpdated> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NodeUpdatedBuilder removeAugmentation(Class<? extends Augmentation<NodeUpdated>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NodeUpdated build() {
        return new NodeUpdatedImpl(this);
    }

    private static final class NodeUpdatedImpl
    implements NodeUpdated {
        private final NodeId _id;
        private final List<NodeConnector> _nodeConnector;
        private final NodeRef _nodeRef;
        private Map<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodeUpdatedImpl(NodeUpdatedBuilder base) {
            this._id = base.getId();
            this._nodeConnector = base.getNodeConnector();
            this._nodeRef = base.getNodeRef();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NodeUpdated> getImplementedInterface() {
            return NodeUpdated.class;
        }

        @Override
        public NodeId getId() {
            return this._id;
        }

        @Override
        public List<NodeConnector> getNodeConnector() {
            return this._nodeConnector;
        }

        @Override
        public NodeRef getNodeRef() {
            return this._nodeRef;
        }

        public <E$$ extends Augmentation<NodeUpdated>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._nodeConnector);
            result = 31 * result + Objects.hashCode(this._nodeRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NodeUpdated.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NodeUpdated other = (NodeUpdated)obj;
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._nodeConnector, other.getNodeConnector())) {
                return false;
            }
            if (!Objects.equals(this._nodeRef, other.getNodeRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeUpdatedImpl otherImpl = (NodeUpdatedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NodeUpdated");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", (Object)this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nodeConnector", this._nodeConnector);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nodeRef", (Object)this._nodeRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

