/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.access.client.ProgressTracker;

@NotThreadSafe
final class AveragingProgressTracker
extends ProgressTracker {
    private static final long DEFAULT_TICKS_PER_TASK = TimeUnit.MILLISECONDS.toNanos(500L);
    private final long tasksOpenLimit;
    private final long noDelayThreshold;

    private AveragingProgressTracker(long limit, long ticksPerTask) {
        super(ticksPerTask);
        this.tasksOpenLimit = limit;
        this.noDelayThreshold = limit / 2L;
    }

    AveragingProgressTracker(long limit) {
        this(limit, DEFAULT_TICKS_PER_TASK);
    }

    AveragingProgressTracker(ProgressTracker oldTracker, long limit, long now) {
        super(oldTracker, now);
        this.tasksOpenLimit = limit;
        this.noDelayThreshold = limit / 2L;
    }

    AveragingProgressTracker(AveragingProgressTracker oldTracker, long now) {
        this(oldTracker, oldTracker.tasksOpenLimit, now);
    }

    @Override
    protected long estimateIsolatedDelay(long now) {
        long open = this.tasksOpen();
        if (open <= this.noDelayThreshold) {
            return 0L;
        }
        if (open >= this.tasksOpenLimit) {
            return this.defaultTicksPerTask();
        }
        double relativeRemainingCapacity = 1.0 - (double)open / (double)this.tasksOpenLimit;
        double delayCoefficient = (0.5 - relativeRemainingCapacity) / relativeRemainingCapacity;
        long delay = (long)(this.ticksWorkedPerClosedTask(now) * delayCoefficient);
        return Math.min(delay, this.defaultTicksPerTask());
    }
}

