/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.StampedLock;
import org.opendaylight.controller.cluster.access.client.InversibleLockException;

@Beta
public final class InversibleLock {
    private static final AtomicReferenceFieldUpdater<InversibleLock, CountDownLatch> LATCH_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InversibleLock.class, CountDownLatch.class, "latch");
    private final StampedLock lock = new StampedLock();
    private volatile CountDownLatch latch;

    public long optimisticRead() {
        CountDownLatch local;
        do {
            long stamp;
            if ((stamp = this.lock.tryOptimisticRead()) == 0L) continue;
            return stamp;
        } while ((local = this.latch) == null);
        throw new InversibleLockException(local);
    }

    public boolean validate(long stamp) {
        return this.lock.validate(stamp);
    }

    public long writeLock() {
        CountDownLatch local = new CountDownLatch(1);
        boolean taken = LATCH_UPDATER.compareAndSet(this, null, local);
        Verify.verify((boolean)taken);
        return this.lock.writeLock();
    }

    public void unlockWrite(long stamp) {
        CountDownLatch local = LATCH_UPDATER.getAndSet(this, null);
        Verify.verifyNotNull((Object)local);
        this.lock.unlockWrite(stamp);
        local.countDown();
    }
}

