/*
 * Decompiled with CFR 0.152.
 */
package rpcbenchmark.impl;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.GlobalRpcBenchInput;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.GlobalRpcBenchInputBuilder;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.GlobalRpcBenchOutput;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchPayloadService;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadBuilder;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpcbenchmark.impl.RTCClient;

public class GlobalBindingRTCClient
implements RTCClient {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalBindingRTCClient.class);
    private final RpcbenchPayloadService service;
    private final AtomicLong rpcOk = new AtomicLong(0L);
    private final AtomicLong rpcError = new AtomicLong(0L);
    private final GlobalRpcBenchInput inVal;
    private final int inSize;

    @Override
    public long getRpcOk() {
        return this.rpcOk.get();
    }

    @Override
    public long getRpcError() {
        return this.rpcError.get();
    }

    public GlobalBindingRTCClient(RpcConsumerRegistry registry, int inSize) {
        this.service = registry != null ? (RpcbenchPayloadService)registry.getRpcService(RpcbenchPayloadService.class) : null;
        this.inSize = inSize;
        ArrayList<Payload> listVals = new ArrayList<Payload>();
        for (int i = 0; i < inSize; ++i) {
            listVals.add(new PayloadBuilder().setId(Integer.valueOf(i)).build());
        }
        this.inVal = new GlobalRpcBenchInputBuilder().setPayload(listVals).build();
    }

    @Override
    public void runTest(int iterations) {
        int rpcOk = 0;
        int rpcError = 0;
        for (int i = 0; i < iterations; ++i) {
            ListenableFuture output = this.service.globalRpcBench(this.inVal);
            try {
                RpcResult rpcResult = (RpcResult)output.get();
                if (!rpcResult.isSuccessful()) continue;
                List retVal = ((GlobalRpcBenchOutput)rpcResult.getResult()).getPayload();
                if (retVal.size() == this.inSize) {
                    ++rpcOk;
                    continue;
                }
                ++rpcError;
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                ++rpcError;
                LOG.error("Execution failed: ", (Throwable)e);
            }
        }
        this.rpcOk.addAndGet(rpcOk);
        this.rpcError.addAndGet(rpcError);
    }

    @Override
    public void close() {
    }
}

