/*
 * Decompiled with CFR 0.152.
 */
package rpcbenchmark.impl;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.NodeContext;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchPayloadService;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRoute;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRouteKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.RpcbenchmarkService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutputBuilder;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpcbenchmark.impl.GlobalBindingRTCClient;
import rpcbenchmark.impl.GlobalBindingRTCServer;
import rpcbenchmark.impl.RTCClient;
import rpcbenchmark.impl.RoutedBindingRTClient;

public class RpcbenchmarkProvider
implements AutoCloseable,
RpcbenchmarkService {
    private static final Logger LOG = LoggerFactory.getLogger(RpcbenchmarkProvider.class);
    private static final int testTimeout = 5;
    private final GlobalBindingRTCServer globalServer;
    private final AtomicReference<TestStatusOutput.ExecStatus> execStatus = new AtomicReference<TestStatusOutput.ExecStatus>(TestStatusOutput.ExecStatus.Idle);
    private final RpcProviderRegistry providerRegistry;

    public RpcbenchmarkProvider(RpcProviderRegistry providerRegistry, GlobalBindingRTCServer globalServer) {
        this.providerRegistry = providerRegistry;
        this.globalServer = globalServer;
    }

    public void init() {
        LOG.info("RpcbenchmarkProvider initiated");
    }

    @Override
    public void close() {
        LOG.info("RpcbenchmarkProvider closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<RpcResult<StartTestOutput>> startTest(StartTestInput input) {
        RTCClient client;
        LOG.debug("startTest {}", (Object)input);
        ArrayList<BindingAwareBroker.RoutedRpcRegistration> rpcRegs = new ArrayList<BindingAwareBroker.RoutedRpcRegistration>();
        switch (input.getOperation()) {
            case ROUTEDRTC: {
                ArrayList routeIid = new ArrayList();
                for (int i = 0; i < input.getNumServers().intValue(); ++i) {
                    GlobalBindingRTCServer server = new GlobalBindingRTCServer();
                    BindingAwareBroker.RoutedRpcRegistration routedReg = this.providerRegistry.addRoutedRpcImplementation(RpcbenchPayloadService.class, (RpcService)server);
                    KeyedInstanceIdentifier iid = InstanceIdentifier.create(RpcbenchRpcRoutes.class).child(RpcRoute.class, (Identifier)new RpcRouteKey(Integer.toString(i)));
                    routeIid.add((InstanceIdentifier<?>)iid);
                    routedReg.registerPath(NodeContext.class, (Path)iid);
                    rpcRegs.add(routedReg);
                }
                client = new RoutedBindingRTClient((RpcConsumerRegistry)this.providerRegistry, input.getPayloadSize().intValue(), routeIid);
                break;
            }
            case GLOBALRTC: {
                client = new GlobalBindingRTCClient((RpcConsumerRegistry)this.providerRegistry, input.getPayloadSize().intValue());
                break;
            }
            default: {
                LOG.error("Unsupported server/client type {}", (Object)input.getOperation());
                throw new IllegalArgumentException("Unsupported server/client type" + input.getOperation());
            }
        }
        try {
            ExecutorService executor = Executors.newFixedThreadPool(input.getNumClients().intValue());
            Runnable testRun = () -> client.runTest(input.getIterations().intValue());
            LOG.info("Test Started");
            long startTime = System.nanoTime();
            for (int i = 0; i < input.getNumClients().intValue(); ++i) {
                executor.submit(testRun);
            }
            executor.shutdown();
            try {
                executor.awaitTermination(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                LOG.error("Out of time: test did not finish within the {} min deadline ", (Object)5);
            }
            long endTime = System.nanoTime();
            LOG.info("Test Done");
            long elapsedTime = endTime - startTime;
            StartTestOutput output = new StartTestOutputBuilder().setRate(Long.valueOf(0L)).setGlobalRtcClientError(Long.valueOf(client.getRpcError())).setGlobalRtcClientOk(Long.valueOf(client.getRpcOk())).setExecTime(Long.valueOf(TimeUnit.NANOSECONDS.toMillis(elapsedTime))).setRate(Long.valueOf((client.getRpcOk() + client.getRpcError()) * 1000000000L / elapsedTime)).build();
            FluentFuture fluentFuture = RpcResultBuilder.success((Object)output).buildFuture();
            return fluentFuture;
        }
        finally {
            for (BindingAwareBroker.RoutedRpcRegistration routedRpcRegistration : rpcRegs) {
                routedRpcRegistration.close();
            }
        }
    }

    public ListenableFuture<RpcResult<TestStatusOutput>> testStatus(TestStatusInput input) {
        LOG.info("testStatus");
        TestStatusOutput output = new TestStatusOutputBuilder().setGlobalServerCnt(Long.valueOf(this.globalServer.getNumRpcs())).setExecStatus(this.execStatus.get()).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }
}

