/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.javax.persistence;

import java.lang.reflect.Method;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class EMFBuilderServiceResolver
implements PersistenceProvider,
ProviderUtil {
    private final ServiceTracker<Object, Object> tracker;

    public EMFBuilderServiceResolver(BundleContext context) {
        this.tracker = new ServiceTracker(context, "org.osgi.service.jpa.EntityManagerFactoryBuilder", null);
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    @Override
    public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        for (Map.Entry e : this.tracker.getTracked().entrySet()) {
            String serviceUnitName = String.valueOf(((ServiceReference)e.getKey()).getProperty("osgi.unit.name"));
            if (!serviceUnitName.equals(emName)) continue;
            try {
                Object emfBuilder = e.getValue();
                Method m = emfBuilder.getClass().getMethod("createEntityManagerFactory", Map.class);
                return (EntityManagerFactory)m.invoke(emfBuilder, map);
            }
            catch (Exception ex) {
                throw new PersistenceException("Failed to create an EntityManagerFactory for unit " + emName, ex);
            }
        }
        return null;
    }

    @Override
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        return null;
    }

    @Override
    public ProviderUtil getProviderUtil() {
        return this;
    }

    @Override
    public LoadState isLoadedWithoutReference(Object entity, String attributeName) {
        return LoadState.UNKNOWN;
    }

    @Override
    public LoadState isLoadedWithReference(Object entity, String attributeName) {
        return LoadState.UNKNOWN;
    }

    @Override
    public LoadState isLoaded(Object entity) {
        return LoadState.UNKNOWN;
    }

    @Override
    public void generateSchema(PersistenceUnitInfo arg0, Map arg1) {
    }

    @Override
    public boolean generateSchema(String arg0, Map arg1) {
        return false;
    }
}

