/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.api;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class AbstractBrokerAwareActivator
implements BundleActivator {
    private static final ExecutorService MD_ACTIVATION_POOL = Executors.newCachedThreadPool();
    private BundleContext context;
    private ServiceTracker<BindingAwareBroker, BindingAwareBroker> tracker;
    private BindingAwareBroker broker;
    private final ServiceTrackerCustomizer<BindingAwareBroker, BindingAwareBroker> customizer = new ServiceTrackerCustomizer<BindingAwareBroker, BindingAwareBroker>(){

        public BindingAwareBroker addingService(ServiceReference<BindingAwareBroker> reference) {
            AbstractBrokerAwareActivator.this.broker = (BindingAwareBroker)AbstractBrokerAwareActivator.this.context.getService(reference);
            MD_ACTIVATION_POOL.execute(() -> AbstractBrokerAwareActivator.this.onBrokerAvailable(AbstractBrokerAwareActivator.this.broker, AbstractBrokerAwareActivator.this.context));
            return AbstractBrokerAwareActivator.this.broker;
        }

        public void modifiedService(ServiceReference<BindingAwareBroker> reference, BindingAwareBroker service) {
            this.removedService(reference, service);
            this.addingService((ServiceReference)reference);
        }

        public void removedService(ServiceReference<BindingAwareBroker> reference, BindingAwareBroker service) {
            AbstractBrokerAwareActivator.this.broker = (BindingAwareBroker)AbstractBrokerAwareActivator.this.context.getService(reference);
            MD_ACTIVATION_POOL.execute(() -> AbstractBrokerAwareActivator.this.onBrokerRemoved(AbstractBrokerAwareActivator.this.broker, AbstractBrokerAwareActivator.this.context));
        }
    };

    public final void start(BundleContext bundleContext) {
        this.context = bundleContext;
        this.startImpl(bundleContext);
        this.tracker = new ServiceTracker(bundleContext, BindingAwareBroker.class, this.customizer);
        this.tracker.open();
    }

    public final void stop(BundleContext bundleContext) {
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.stopImpl(bundleContext);
    }

    protected void startImpl(BundleContext bundleContext) {
    }

    protected void stopImpl(BundleContext bundleContext) {
    }

    protected abstract void onBrokerAvailable(BindingAwareBroker var1, BundleContext var2);

    protected void onBrokerRemoved(BindingAwareBroker bindingBroker, BundleContext bundleContext) {
        this.stopImpl(bundleContext);
    }
}

