/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.services.BlueprintExtenderService;
import org.apache.aries.quiesce.participant.QuiesceParticipant;
import org.apache.aries.util.AriesFrameworkUtil;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.blueprint.BlueprintContainerRestartService;
import org.opendaylight.controller.blueprint.BlueprintContainerRestartServiceImpl;
import org.opendaylight.controller.blueprint.ext.OpendaylightNamespaceHandler;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintBundleTracker
implements BundleActivator,
BundleTrackerCustomizer<Bundle>,
BlueprintListener,
SynchronousBundleListener {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintBundleTracker.class);
    private static final String ODL_CUSTOM_BLUEPRINT_FILE_PATH = "org/opendaylight/blueprint/";
    private static final String STANDARD_BLUEPRINT_FILE_PATH = "OSGI-INF/blueprint/";
    private static final String BLUEPRINT_FLE_PATTERN = "*.xml";
    private static final long SYSTEM_BUNDLE_ID = 0L;
    private ServiceTracker<BlueprintExtenderService, BlueprintExtenderService> blueprintExtenderServiceTracker;
    private ServiceTracker<QuiesceParticipant, QuiesceParticipant> quiesceParticipantTracker;
    private BundleTracker<Bundle> bundleTracker;
    private BundleContext bundleContext;
    private volatile BlueprintExtenderService blueprintExtenderService;
    private volatile QuiesceParticipant quiesceParticipant;
    private volatile ServiceRegistration<?> blueprintContainerRestartReg;
    private volatile BlueprintContainerRestartServiceImpl restartService;
    private volatile boolean shuttingDown;
    private ServiceRegistration<?> eventHandlerReg;
    private ServiceRegistration<?> namespaceReg;

    public void start(BundleContext context) {
        LOG.info("Starting {}", (Object)this.getClass().getSimpleName());
        UntrustedXML.newDocumentBuilder();
        this.restartService = new BlueprintContainerRestartServiceImpl();
        this.bundleContext = context;
        this.registerBlueprintEventHandler(context);
        this.registerNamespaceHandler(context);
        this.bundleTracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)this);
        this.blueprintExtenderServiceTracker = new ServiceTracker(context, BlueprintExtenderService.class.getName(), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<BlueprintExtenderService, BlueprintExtenderService>(){

            public BlueprintExtenderService addingService(ServiceReference<BlueprintExtenderService> reference) {
                return BlueprintBundleTracker.this.onBlueprintExtenderServiceAdded((ServiceReference<BlueprintExtenderService>)reference);
            }

            public void modifiedService(ServiceReference<BlueprintExtenderService> reference, BlueprintExtenderService service) {
            }

            public void removedService(ServiceReference<BlueprintExtenderService> reference, BlueprintExtenderService service) {
            }
        });
        this.blueprintExtenderServiceTracker.open();
        this.quiesceParticipantTracker = new ServiceTracker(context, QuiesceParticipant.class.getName(), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<QuiesceParticipant, QuiesceParticipant>(){

            public QuiesceParticipant addingService(ServiceReference<QuiesceParticipant> reference) {
                return BlueprintBundleTracker.this.onQuiesceParticipantAdded((ServiceReference<QuiesceParticipant>)reference);
            }

            public void modifiedService(ServiceReference<QuiesceParticipant> reference, QuiesceParticipant service) {
            }

            public void removedService(ServiceReference<QuiesceParticipant> reference, QuiesceParticipant service) {
            }
        });
        this.quiesceParticipantTracker.open();
    }

    private QuiesceParticipant onQuiesceParticipantAdded(ServiceReference<QuiesceParticipant> reference) {
        this.quiesceParticipant = (QuiesceParticipant)reference.getBundle().getBundleContext().getService(reference);
        LOG.debug("Got QuiesceParticipant");
        this.restartService.setQuiesceParticipant(this.quiesceParticipant);
        return this.quiesceParticipant;
    }

    private BlueprintExtenderService onBlueprintExtenderServiceAdded(ServiceReference<BlueprintExtenderService> reference) {
        this.blueprintExtenderService = (BlueprintExtenderService)reference.getBundle().getBundleContext().getService(reference);
        this.bundleTracker.open();
        this.bundleContext.addBundleListener((BundleListener)this);
        LOG.debug("Got BlueprintExtenderService");
        this.restartService.setBlueprintExtenderService(this.blueprintExtenderService);
        this.blueprintContainerRestartReg = this.bundleContext.registerService(BlueprintContainerRestartService.class.getName(), (Object)this.restartService, new Hashtable());
        return this.blueprintExtenderService;
    }

    private void registerNamespaceHandler(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.service.blueprint.namespace", "http://opendaylight.org/xmlns/blueprint/v1.0.0");
        this.namespaceReg = context.registerService(NamespaceHandler.class.getName(), (Object)new OpendaylightNamespaceHandler(), props);
    }

    private void registerBlueprintEventHandler(BundleContext context) {
        this.eventHandlerReg = context.registerService(BlueprintListener.class.getName(), (Object)this, new Hashtable());
    }

    public void stop(BundleContext context) {
        this.bundleTracker.close();
        this.blueprintExtenderServiceTracker.close();
        this.quiesceParticipantTracker.close();
        AriesFrameworkUtil.safeUnregisterService(this.eventHandlerReg);
        AriesFrameworkUtil.safeUnregisterService(this.namespaceReg);
        AriesFrameworkUtil.safeUnregisterService(this.blueprintContainerRestartReg);
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getBundle().getBundleId() == 0L && event.getType() == 256) {
            this.shutdownAllContainers();
        }
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        this.modifiedBundle(bundle, event, bundle);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        List<Object> paths;
        if (this.shuttingDown) {
            return;
        }
        if (bundle.getState() == 32 && !(paths = BlueprintBundleTracker.findBlueprintPaths(bundle, ODL_CUSTOM_BLUEPRINT_FILE_PATH)).isEmpty()) {
            LOG.info("Creating blueprint container for bundle {} with paths {}", (Object)bundle, paths);
            this.blueprintExtenderService.createContainer(bundle, paths);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
    }

    public void blueprintEvent(BlueprintEvent event) {
        Bundle bundle;
        List<Object> paths;
        if (event.getType() == 2) {
            LOG.info("Blueprint container for bundle {} was successfully created", (Object)event.getBundle());
            return;
        }
        if (event.getType() == 5 && event.getDependencies() != null && !(paths = BlueprintBundleTracker.findBlueprintPaths(bundle = event.getBundle())).isEmpty()) {
            LOG.warn("Blueprint container for bundle {} timed out waiting for dependencies - restarting it", (Object)bundle);
            this.restartService.restartContainer(bundle, paths);
        }
    }

    static List<Object> findBlueprintPaths(Bundle bundle) {
        List<Object> paths = BlueprintBundleTracker.findBlueprintPaths(bundle, STANDARD_BLUEPRINT_FILE_PATH);
        return !paths.isEmpty() ? paths : BlueprintBundleTracker.findBlueprintPaths(bundle, ODL_CUSTOM_BLUEPRINT_FILE_PATH);
    }

    private static List<Object> findBlueprintPaths(Bundle bundle, String path) {
        Enumeration rntries = bundle.findEntries(path, BLUEPRINT_FLE_PATTERN, false);
        if (rntries == null) {
            return Collections.emptyList();
        }
        return Collections.list(rntries);
    }

    private void shutdownAllContainers() {
        this.shuttingDown = true;
        this.restartService.close();
        LOG.info("Shutting down all blueprint containers...");
        HashSet<Bundle> containerBundles = new HashSet<Bundle>(Arrays.asList(this.bundleContext.getBundles()));
        while (!containerBundles.isEmpty()) {
            for (Bundle bundle : this.getBundlesToDestroy(containerBundles)) {
                containerBundles.remove(bundle);
                BlueprintContainer container = this.blueprintExtenderService.getContainer(bundle);
                if (container == null) continue;
                this.blueprintExtenderService.destroyContainer(bundle, container);
            }
        }
        LOG.info("Shutdown of blueprint containers complete");
    }

    private List<Bundle> getBundlesToDestroy(Collection<Bundle> containerBundles) {
        ArrayList<Bundle> bundlesToDestroy = new ArrayList<Bundle>();
        for (Bundle bundle : containerBundles) {
            ServiceReference[] references = bundle.getRegisteredServices();
            int usage = 0;
            if (references != null) {
                for (ServiceReference reference : references) {
                    usage += BlueprintBundleTracker.getServiceUsage(reference);
                }
            }
            LOG.debug("Usage for bundle {} is {}", (Object)bundle, (Object)usage);
            if (usage != 0) continue;
            bundlesToDestroy.add(bundle);
        }
        if (!bundlesToDestroy.isEmpty()) {
            bundlesToDestroy.sort((b1, b2) -> (int)(b2.getLastModified() - b1.getLastModified()));
            LOG.debug("Selected bundles {} for destroy (no services in use)", bundlesToDestroy);
        } else {
            Bundle bundle = this.findBundleWithHighestUsedServiceId(containerBundles);
            if (bundle != null) {
                bundlesToDestroy.add(bundle);
            }
            LOG.debug("Selected bundle {} for destroy (lowest ranking service or highest service ID)", bundlesToDestroy);
        }
        return bundlesToDestroy;
    }

    private @Nullable Bundle findBundleWithHighestUsedServiceId(Collection<Bundle> containerBundles) {
        ServiceReference highestServiceRef = null;
        for (Bundle bundle : containerBundles) {
            ServiceReference[] references = bundle.getRegisteredServices();
            if (references == null) continue;
            for (ServiceReference reference : references) {
                if (BlueprintBundleTracker.getServiceUsage(reference) == 0 || highestServiceRef != null && reference.compareTo(highestServiceRef) >= 0) continue;
                LOG.debug("Currently selecting bundle {} for destroy (with reference {})", (Object)bundle, (Object)reference);
                highestServiceRef = reference;
            }
        }
        return highestServiceRef == null ? null : highestServiceRef.getBundle();
    }

    private static int getServiceUsage(ServiceReference<?> ref) {
        Bundle[] usingBundles = ref.getUsingBundles();
        return usingBundles != null ? usingBundles.length : 0;
    }
}

