/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.aries.blueprint.services.BlueprintExtenderService;
import org.apache.aries.quiesce.participant.QuiesceParticipant;
import org.apache.aries.util.AriesFrameworkUtil;
import org.opendaylight.controller.blueprint.BlueprintBundleTracker;
import org.opendaylight.controller.blueprint.BlueprintContainerRestartService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlueprintContainerRestartServiceImpl
implements AutoCloseable,
BlueprintContainerRestartService {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintContainerRestartServiceImpl.class);
    private static final int CONTAINER_CREATE_TIMEOUT_IN_MINUTES = 5;
    private final ExecutorService restartExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("BlueprintContainerRestartService").build());
    private BlueprintExtenderService blueprintExtenderService;
    private QuiesceParticipant quiesceParticipant;

    BlueprintContainerRestartServiceImpl() {
    }

    void setBlueprintExtenderService(BlueprintExtenderService blueprintExtenderService) {
        this.blueprintExtenderService = blueprintExtenderService;
    }

    void setQuiesceParticipant(QuiesceParticipant quiesceParticipant) {
        this.quiesceParticipant = quiesceParticipant;
    }

    public void restartContainer(Bundle bundle, List<Object> paths) {
        LOG.debug("restartContainer for bundle {}", (Object)bundle);
        if (this.restartExecutor.isShutdown()) {
            LOG.debug("Already closed - returning");
            return;
        }
        this.restartExecutor.execute(() -> {
            this.blueprintExtenderService.destroyContainer(bundle, this.blueprintExtenderService.getContainer(bundle));
            this.blueprintExtenderService.createContainer(bundle, paths);
        });
    }

    @Override
    public void restartContainerAndDependents(Bundle bundle) {
        if (this.restartExecutor.isShutdown()) {
            return;
        }
        LOG.debug("restartContainerAndDependents for bundle {}", (Object)bundle);
        this.restartExecutor.execute(() -> this.restartContainerAndDependentsInternal(bundle));
    }

    private void restartContainerAndDependentsInternal(Bundle forBundle) {
        Preconditions.checkNotNull((Object)this.blueprintExtenderService);
        Preconditions.checkNotNull((Object)this.quiesceParticipant);
        LinkedHashSet<Bundle> containerBundlesSet = new LinkedHashSet<Bundle>();
        this.findDependentContainersRecursively(forBundle, containerBundlesSet);
        ArrayList<Bundle> containerBundles = new ArrayList<Bundle>(containerBundlesSet);
        LOG.info("Restarting blueprint containers for bundle {} and its dependent bundles {}", (Object)forBundle, containerBundles.subList(1, containerBundles.size()));
        CountDownLatch containerCreationComplete = new CountDownLatch(containerBundles.size());
        ServiceRegistration<?> eventHandlerReg = this.registerEventHandler(forBundle.getBundleContext(), event -> {
            Bundle bundle = event.getBundle();
            if (event.isReplay()) {
                LOG.trace("Got replay BlueprintEvent {} for bundle {}", (Object)event.getType(), (Object)bundle);
                return;
            }
            LOG.debug("Got BlueprintEvent {} for bundle {}", (Object)event.getType(), (Object)bundle);
            if (containerBundles.contains(bundle) && (event.getType() == 2 || event.getType() == 5)) {
                containerCreationComplete.countDown();
                LOG.debug("containerCreationComplete is now {}", (Object)containerCreationComplete.getCount());
            }
        });
        Runnable createContainerCallback = () -> this.createContainers(containerBundles);
        this.destroyContainers(new ArrayDeque<Bundle>(Lists.reverse(containerBundles)), createContainerCallback);
        try {
            if (!containerCreationComplete.await(5L, TimeUnit.MINUTES)) {
                LOG.warn("Failed to restart all blueprint containers within {} minutes. Attempted to restart {} {} but only {} completed restart", new Object[]{5, containerBundles.size(), containerBundles, (long)containerBundles.size() - containerCreationComplete.getCount()});
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.debug("CountDownLatch await was interrupted - returning");
            return;
        }
        AriesFrameworkUtil.safeUnregisterService(eventHandlerReg);
        LOG.info("Finished restarting blueprint containers for bundle {} and its dependent bundles", (Object)forBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyContainers(Deque<Bundle> remainingBundlesToDestroy, Runnable createContainerCallback) {
        Bundle nextBundle;
        Deque<Bundle> deque = remainingBundlesToDestroy;
        synchronized (deque) {
            if (remainingBundlesToDestroy.isEmpty()) {
                LOG.debug("All blueprint containers were quiesced and destroyed");
                createContainerCallback.run();
                return;
            }
            nextBundle = remainingBundlesToDestroy.poll();
        }
        this.quiesceParticipant.quiesce(bundlesQuiesced -> {
            Arrays.stream(bundlesQuiesced).forEach(quiescedBundle -> {
                LOG.debug("Quiesced bundle {}", quiescedBundle);
                this.blueprintExtenderService.destroyContainer(quiescedBundle, this.blueprintExtenderService.getContainer(quiescedBundle));
            });
            this.destroyContainers(remainingBundlesToDestroy, createContainerCallback);
        }, Collections.singletonList(nextBundle));
    }

    private void createContainers(List<Bundle> containerBundles) {
        containerBundles.forEach(bundle -> {
            List<Object> paths = BlueprintBundleTracker.findBlueprintPaths(bundle);
            LOG.info("Restarting blueprint container for bundle {} with paths {}", bundle, paths);
            this.blueprintExtenderService.createContainer(bundle, paths);
        });
    }

    private void findDependentContainersRecursively(Bundle bundle, Set<Bundle> containerBundles) {
        if (!containerBundles.add(bundle)) {
            return;
        }
        ServiceReference[] references = bundle.getRegisteredServices();
        if (references != null) {
            for (ServiceReference reference : references) {
                Bundle[] usingBundles = reference.getUsingBundles();
                if (usingBundles == null) continue;
                for (Bundle usingBundle : usingBundles) {
                    if (this.blueprintExtenderService.getContainer(usingBundle) == null) continue;
                    this.findDependentContainersRecursively(usingBundle, containerBundles);
                }
            }
        }
    }

    private ServiceRegistration<?> registerEventHandler(BundleContext bundleContext, BlueprintListener listener) {
        return bundleContext.registerService(BlueprintListener.class.getName(), (Object)listener, new Hashtable());
    }

    @Override
    public void close() {
        LOG.debug("Closing");
        this.restartExecutor.shutdownNow();
    }
}

