/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.blueprint.ext.AbstractDependentComponentFactoryMetadata;
import org.opendaylight.controller.blueprint.ext.BindingContext;
import org.opendaylight.controller.blueprint.ext.ConfigXMLReaderException;
import org.opendaylight.controller.blueprint.ext.DataStoreAppConfigDefaultXMLReader;
import org.opendaylight.controller.blueprint.ext.UpdateStrategy;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DataStoreAppConfigMetadata
extends AbstractDependentComponentFactoryMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(DataStoreAppConfigMetadata.class);
    static final String BINDING_CLASS = "binding-class";
    static final String DEFAULT_CONFIG = "default-config";
    static final String DEFAULT_CONFIG_FILE_NAME = "default-config-file-name";
    static final String LIST_KEY_VALUE = "list-key-value";
    private static final String DEFAULT_APP_CONFIG_FILE_PATH = "etc" + File.separator + "opendaylight" + File.separator + "datastore" + File.separator + "initial" + File.separator + "config";
    private final Element defaultAppConfigElement;
    private final String defaultAppConfigFileName;
    private final String appConfigBindingClassName;
    private final String appConfigListKeyValue;
    private final UpdateStrategy appConfigUpdateStrategy;
    private final AtomicBoolean readingInitialAppConfig = new AtomicBoolean(true);
    private volatile BindingContext bindingContext;
    private volatile ListenerRegistration<?> appConfigChangeListenerReg;
    private volatile DataObject currentAppConfig;
    private volatile BindingNormalizedNodeSerializer bindingSerializer;

    public DataStoreAppConfigMetadata(String id, @NonNull String appConfigBindingClassName, @Nullable String appConfigListKeyValue, @Nullable String defaultAppConfigFileName, @NonNull UpdateStrategy updateStrategyValue, @Nullable Element defaultAppConfigElement) {
        super(id);
        this.defaultAppConfigElement = defaultAppConfigElement;
        this.defaultAppConfigFileName = defaultAppConfigFileName;
        this.appConfigBindingClassName = appConfigBindingClassName;
        this.appConfigListKeyValue = appConfigListKeyValue;
        this.appConfigUpdateStrategy = updateStrategyValue;
    }

    @Override
    public void init(ExtendedBlueprintContainer container) {
        Class appConfigBindingClass;
        super.init(container);
        try {
            Class bindingClass = container.getBundleContext().getBundle().loadClass(this.appConfigBindingClassName);
            if (!DataObject.class.isAssignableFrom(bindingClass)) {
                throw new ComponentDefinitionException(String.format("%s: Specified app config binding class %s does not extend %s", this.logName(), this.appConfigBindingClassName, DataObject.class.getName()));
            }
            appConfigBindingClass = bindingClass;
        }
        catch (ClassNotFoundException e) {
            throw new ComponentDefinitionException(String.format("%s: Error loading app config binding class %s", this.logName(), this.appConfigBindingClassName), (Throwable)e);
        }
        this.bindingContext = BindingContext.create(this.logName(), appConfigBindingClass, this.appConfigListKeyValue);
    }

    public Object create() throws ComponentDefinitionException {
        LOG.debug("{}: In create - currentAppConfig: {}", (Object)this.logName(), (Object)this.currentAppConfig);
        super.onCreate();
        return this.currentAppConfig;
    }

    @Override
    protected void startTracking() {
        this.retrieveService("binding-codec", BindingNormalizedNodeSerializer.class, (Object service) -> {
            this.bindingSerializer = (BindingNormalizedNodeSerializer)service;
            this.retrieveDataBrokerService();
        });
    }

    private void retrieveDataBrokerService() {
        LOG.debug("{}: In retrieveDataBrokerService", (Object)this.logName());
        this.retrieveService("data-broker", DataBroker.class, (Object service) -> this.retrieveInitialAppConfig((DataBroker)service));
    }

    private void retrieveInitialAppConfig(DataBroker dataBroker) {
        LOG.debug("{}: Got DataBroker instance - reading app config {}", (Object)this.logName(), this.bindingContext.appConfigPath);
        this.setDependencyDesc("Initial app config " + this.bindingContext.appConfigBindingClass.getSimpleName());
        DataTreeIdentifier dataTreeId = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, this.bindingContext.appConfigPath);
        this.appConfigChangeListenerReg = dataBroker.registerDataTreeChangeListener(dataTreeId, (DataTreeChangeListener)((ClusteredDataTreeChangeListener)this::onAppConfigChanged));
        this.readInitialAppConfig(dataBroker);
    }

    private void readInitialAppConfig(final DataBroker dataBroker) {
        FluentFuture future;
        try (ReadTransaction readOnlyTx = dataBroker.newReadOnlyTransaction();){
            future = readOnlyTx.read(LogicalDatastoreType.CONFIGURATION, this.bindingContext.appConfigPath);
        }
        future.addCallback((FutureCallback)new FutureCallback<Optional<DataObject>>(){

            public void onSuccess(Optional<DataObject> possibleAppConfig) {
                LOG.debug("{}: Read of app config {} succeeded: {}", new Object[]{DataStoreAppConfigMetadata.this.logName(), ((DataStoreAppConfigMetadata)DataStoreAppConfigMetadata.this).bindingContext.appConfigBindingClass.getName(), possibleAppConfig});
                DataStoreAppConfigMetadata.this.setInitialAppConfig(possibleAppConfig);
            }

            public void onFailure(Throwable failure) {
                if (DataStoreAppConfigMetadata.this.readingInitialAppConfig.get()) {
                    LOG.warn("{}: Read of app config {} failed - retrying", new Object[]{DataStoreAppConfigMetadata.this.logName(), ((DataStoreAppConfigMetadata)DataStoreAppConfigMetadata.this).bindingContext.appConfigBindingClass.getName(), failure});
                    DataStoreAppConfigMetadata.this.readInitialAppConfig(dataBroker);
                }
            }
        }, MoreExecutors.directExecutor());
    }

    private void onAppConfigChanged(Collection<DataTreeModification<DataObject>> changes) {
        for (DataTreeModification<DataObject> change : changes) {
            DataObjectModification changeRoot = change.getRootNode();
            DataObjectModification.ModificationType type = changeRoot.getModificationType();
            LOG.debug("{}: onAppConfigChanged: {}, {}", new Object[]{this.logName(), type, change.getRootPath()});
            if (type == DataObjectModification.ModificationType.SUBTREE_MODIFIED || type == DataObjectModification.ModificationType.WRITE) {
                DataObject newAppConfig = changeRoot.getDataAfter();
                LOG.debug("New app config instance: {}, previous: {}", (Object)newAppConfig, (Object)this.currentAppConfig);
                if (this.setInitialAppConfig(Optional.of(newAppConfig)) || Objects.equals(this.currentAppConfig, newAppConfig)) continue;
                LOG.debug("App config was updated");
                if (this.appConfigUpdateStrategy != UpdateStrategy.RELOAD) continue;
                this.restartContainer();
                continue;
            }
            if (type != DataObjectModification.ModificationType.DELETE) continue;
            LOG.debug("App config was deleted");
            if (this.appConfigUpdateStrategy != UpdateStrategy.RELOAD) continue;
            this.restartContainer();
        }
    }

    private boolean setInitialAppConfig(Optional<DataObject> possibleAppConfig) {
        boolean result = this.readingInitialAppConfig.compareAndSet(true, false);
        if (result) {
            DataObject localAppConfig = possibleAppConfig.isPresent() ? possibleAppConfig.get() : this.createDefaultInstance();
            LOG.debug("{}: Setting currentAppConfig instance: {}", (Object)this.logName(), (Object)localAppConfig);
            this.currentAppConfig = localAppConfig;
            this.setSatisfied();
        }
        return result;
    }

    private DataObject createDefaultInstance() {
        try {
            DataStoreAppConfigDefaultXMLReader.ConfigURLProvider inputStreamProvider = appConfigFileName -> {
                File appConfigFile = new File(DEFAULT_APP_CONFIG_FILE_PATH, appConfigFileName);
                LOG.debug("{}: parsePossibleDefaultAppConfigXMLFile looking for file {}", (Object)this.logName(), (Object)appConfigFile.getAbsolutePath());
                if (!appConfigFile.exists()) {
                    return Optional.empty();
                }
                LOG.debug("{}: Found file {}", (Object)this.logName(), (Object)appConfigFile.getAbsolutePath());
                return Optional.of(appConfigFile.toURI().toURL());
            };
            DataStoreAppConfigDefaultXMLReader reader = new DataStoreAppConfigDefaultXMLReader(this.logName(), this.defaultAppConfigFileName, this.getOSGiService(DOMSchemaService.class), this.bindingSerializer, this.bindingContext, inputStreamProvider);
            return reader.createDefaultInstance((schemaContext, dataSchema) -> {
                NormalizedNode<?, ?> dataNode = this.parsePossibleDefaultAppConfigElement(schemaContext, dataSchema);
                if (dataNode == null) {
                    return this.bindingContext.newDefaultNode(dataSchema);
                }
                return dataNode;
            });
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | XMLStreamException | ConfigXMLReaderException | SAXException e) {
            if (e.getCause() == null) {
                this.setFailureMessage(e.getMessage());
            } else {
                this.setFailure(e.getMessage(), e);
            }
            return null;
        }
    }

    private @Nullable NormalizedNode<?, ?> parsePossibleDefaultAppConfigElement(SchemaContext schemaContext, DataSchemaNode dataSchema) throws URISyntaxException, IOException, ParserConfigurationException, SAXException, XMLStreamException {
        if (this.defaultAppConfigElement == null) {
            return null;
        }
        LOG.debug("{}: parsePossibleDefaultAppConfigElement for {}", (Object)this.logName(), (Object)this.bindingContext.bindingQName);
        LOG.debug("{}: Got app config schema: {}", (Object)this.logName(), (Object)dataSchema);
        NormalizedNode<?, ?> dataNode = this.bindingContext.parseDataElement(this.defaultAppConfigElement, dataSchema, schemaContext);
        LOG.debug("{}: Parsed data node: {}", (Object)this.logName(), dataNode);
        return dataNode;
    }

    @Override
    public void destroy(Object instance) {
        super.destroy(instance);
        if (this.appConfigChangeListenerReg != null) {
            this.appConfigChangeListenerReg.close();
            this.appConfigChangeListenerReg = null;
        }
    }
}

