/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcImplementationBean {
    private static final Logger LOG = LoggerFactory.getLogger(RpcImplementationBean.class);
    static final String RPC_IMPLEMENTATION = "rpc-implementation";
    private RpcProviderService rpcProvider;
    private Bundle bundle;
    private String interfaceName;
    private RpcService implementation;
    private final List<ObjectRegistration<RpcService>> rpcRegistrations = new ArrayList<ObjectRegistration<RpcService>>();

    public void setRpcProvider(RpcProviderService rpcProvider) {
        this.rpcProvider = rpcProvider;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public void setImplementation(RpcService implementation) {
        this.implementation = implementation;
    }

    public void init() {
        try {
            List<Class<RpcService>> rpcInterfaces = RpcImplementationBean.getImplementedRpcServiceInterfaces(this.interfaceName, this.implementation.getClass(), this.bundle, RPC_IMPLEMENTATION);
            LOG.debug("{}: init - adding implementation {} for RpcService interface(s) {}", new Object[]{this.bundle.getSymbolicName(), this.implementation, rpcInterfaces});
            for (Class<RpcService> rpcInterface : rpcInterfaces) {
                this.rpcRegistrations.add((ObjectRegistration<RpcService>)this.rpcProvider.registerRpcImplementation(rpcInterface, this.implementation));
            }
        }
        catch (ComponentDefinitionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ComponentDefinitionException(String.format("Error processing \"%s\" for %s", RPC_IMPLEMENTATION, this.implementation.getClass()), (Throwable)e);
        }
    }

    public void destroy() {
        for (ObjectRegistration<RpcService> reg : this.rpcRegistrations) {
            reg.close();
        }
    }

    static List<Class<RpcService>> getImplementedRpcServiceInterfaces(String interfaceName, Class<?> implementationClass, Bundle bundle, String logName) throws ClassNotFoundException {
        if (!Strings.isNullOrEmpty((String)interfaceName)) {
            Class rpcInterface = bundle.loadClass(interfaceName);
            if (!rpcInterface.isAssignableFrom(implementationClass)) {
                throw new ComponentDefinitionException(String.format("The specified \"interface\" %s for \"%s\" is not implemented by RpcService \"ref\" %s", interfaceName, logName, implementationClass));
            }
            return Collections.singletonList(rpcInterface);
        }
        ArrayList<Class<RpcService>> rpcInterfaces = new ArrayList<Class<RpcService>>();
        for (Class<?> intface : implementationClass.getInterfaces()) {
            if (!RpcService.class.isAssignableFrom(intface)) continue;
            rpcInterfaces.add(intface);
        }
        if (rpcInterfaces.isEmpty()) {
            throw new ComponentDefinitionException(String.format("The \"ref\" instance %s for \"%s\" does not implemented any RpcService interfaces", implementationClass, logName));
        }
        return rpcInterfaces;
    }
}

