/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import org.opendaylight.controller.blueprint.ext.AbstractDependentComponentFactoryMetadata;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StaticReferenceMetadata
extends AbstractDependentComponentFactoryMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(StaticReferenceMetadata.class);
    private final String interfaceName;
    private volatile Object retrievedService;

    StaticReferenceMetadata(String id, String interfaceName) {
        super(id);
        this.interfaceName = interfaceName;
    }

    @Override
    protected void startTracking() {
        this.retrieveService(this.interfaceName, this.interfaceName, (Object service) -> {
            this.retrievedService = service;
            this.setSatisfied();
        });
    }

    public Object create() throws ComponentDefinitionException {
        super.onCreate();
        LOG.debug("{}: create returning service {}", (Object)this.logName(), this.retrievedService);
        return this.retrievedService;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StaticReferenceMetadata [interfaceName=").append(this.interfaceName).append("]");
        return builder.toString();
    }
}

