/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.FutureVersionException;
import org.opendaylight.controller.cluster.access.PastVersionException;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public enum ABIVersion implements WritableObject
{
    TEST_PAST_VERSION(0),
    BORON(5),
    TEST_FUTURE_VERSION(65535);

    private static final Logger LOG;
    private final short value;

    private ABIVersion(int intVersion) {
        Preconditions.checkArgument((intVersion >= 0 && intVersion <= 65535 ? 1 : 0) != 0);
        this.value = (short)intVersion;
    }

    public short shortValue() {
        return this.value;
    }

    public static @NonNull ABIVersion current() {
        return BORON;
    }

    public static @NonNull ABIVersion valueOf(short value) throws FutureVersionException, PastVersionException {
        switch (Short.toUnsignedInt(value)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                throw new PastVersionException(value, BORON);
            }
            case 5: {
                return BORON;
            }
        }
        throw new FutureVersionException(value, BORON);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeShort(this.value);
    }

    public static @NonNull ABIVersion readFrom(@NonNull DataInput in) throws IOException {
        short s = in.readShort();
        try {
            return ABIVersion.valueOf(s);
        }
        catch (FutureVersionException | PastVersionException e) {
            throw new IOException("Unsupported version", e);
        }
    }

    public static @NonNull ABIVersion inexactReadFrom(@NonNull DataInput in) throws IOException {
        short onWire = in.readShort();
        try {
            return ABIVersion.valueOf(onWire);
        }
        catch (FutureVersionException e) {
            LOG.debug("Received future version", (Throwable)e);
            return TEST_FUTURE_VERSION;
        }
        catch (PastVersionException e) {
            LOG.debug("Received past version", (Throwable)e);
            return TEST_PAST_VERSION;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ABIVersion.class);
    }
}

