/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.commands.AbstractReadPathTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequestProxyV1;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeInputOutput;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

abstract class AbstractReadPathTransactionRequestProxyV1<T extends AbstractReadPathTransactionRequest<T>>
extends AbstractReadTransactionRequestProxyV1<T> {
    private static final long serialVersionUID = 1L;
    private YangInstanceIdentifier path;

    protected AbstractReadPathTransactionRequestProxyV1() {
    }

    AbstractReadPathTransactionRequestProxyV1(T request) {
        super(request);
        this.path = ((AbstractReadPathTransactionRequest)request).getPath();
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        try (NormalizedNodeDataOutput nnout = NormalizedNodeInputOutput.newDataOutput((DataOutput)out);){
            nnout.writeYangInstanceIdentifier(this.path);
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        super.readExternal(in);
        this.path = NormalizedNodeInputOutput.newDataInput((DataInput)in).readYangInstanceIdentifier();
    }

    @Override
    protected final T createReadRequest(TransactionIdentifier target, long sequence, ActorRef replyTo, boolean snapshotOnly) {
        return this.createReadPathRequest(target, sequence, replyTo, this.path, snapshotOnly);
    }

    abstract T createReadPathRequest(TransactionIdentifier var1, long var2, ActorRef var4, YangInstanceIdentifier var5, boolean var6);
}

