/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.concepts.Envelope;
import org.opendaylight.controller.cluster.access.concepts.Message;
import org.opendaylight.yangtools.concepts.WritableObjects;

abstract class AbstractEnvelopeProxy<T extends Message<?, ?>>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private T message;
    private long sessionId;
    private long txSequence;

    AbstractEnvelopeProxy() {
    }

    AbstractEnvelopeProxy(Envelope<T> envelope) {
        this.message = envelope.getMessage();
        this.txSequence = envelope.getTxSequence();
        this.sessionId = envelope.getSessionId();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WritableObjects.writeLongs((DataOutput)out, (long)this.sessionId, (long)this.txSequence);
        out.writeObject(this.message);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte header = WritableObjects.readLongHeader((DataInput)in);
        this.sessionId = WritableObjects.readFirstLong((DataInput)in, (byte)header);
        this.txSequence = WritableObjects.readSecondLong((DataInput)in, (byte)header);
        this.message = (Message)in.readObject();
    }

    abstract Envelope<T> createEnvelope(T var1, long var2, long var4);

    final Object readResolve() {
        return this.createEnvelope(this.message, this.sessionId, this.txSequence);
    }
}

