/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.AbstractResponseProxy;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public abstract class AbstractRequestFailureProxy<T extends WritableIdentifier, C extends RequestFailure<T, C>>
extends AbstractResponseProxy<T, C> {
    private static final long serialVersionUID = 1L;
    private RequestException cause;

    protected AbstractRequestFailureProxy() {
    }

    protected AbstractRequestFailureProxy(@NonNull C failure) {
        super(failure);
        this.cause = ((RequestFailure)failure).getCause();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.cause);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.cause = (RequestException)in.readObject();
    }

    @Override
    final C createResponse(T target, long sequence) {
        return this.createFailure(target, sequence, this.cause);
    }

    protected abstract @NonNull C createFailure(@NonNull T var1, long var2, @NonNull RequestException var4);
}

