/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import akka.actor.ActorRef;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.concepts.AbstractRequestProxy;
import org.opendaylight.controller.cluster.access.concepts.Message;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public abstract class Request<T extends WritableIdentifier, C extends Request<T, C>>
extends Message<T, C> {
    private static final long serialVersionUID = 1L;
    private final @NonNull ActorRef replyTo;

    protected Request(@NonNull T target, long sequence, @NonNull ActorRef replyTo) {
        super(target, sequence);
        this.replyTo = Objects.requireNonNull(replyTo);
    }

    protected Request(@NonNull C request, @NonNull ABIVersion version) {
        super(request, version);
        this.replyTo = Objects.requireNonNull(((Request)request).getReplyTo());
    }

    public final @NonNull ActorRef getReplyTo() {
        return this.replyTo;
    }

    public abstract @NonNull RequestFailure<T, ?> toRequestFailure(@NonNull RequestException var1);

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("replyTo", (Object)this.replyTo);
    }

    @Override
    protected abstract AbstractRequestProxy<T, C> externalizableProxy(ABIVersion var1);
}

