/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.access.concepts.AbstractResponseEnvelopeProxy;
import org.opendaylight.controller.cluster.access.concepts.Envelope;
import org.opendaylight.controller.cluster.access.concepts.Response;

public abstract class ResponseEnvelope<T extends Response<?, ?>>
extends Envelope<T> {
    private static final long serialVersionUID = 1L;
    private final long executionTimeNanos;

    ResponseEnvelope(T message, long sessionId, long txSequence, long executionTimeNanos) {
        super(message, sessionId, txSequence);
        Preconditions.checkArgument((executionTimeNanos >= 0L ? 1 : 0) != 0);
        this.executionTimeNanos = executionTimeNanos;
    }

    public final long getExecutionTimeNanos() {
        return this.executionTimeNanos;
    }

    @Override
    abstract AbstractResponseEnvelopeProxy<T> createProxy();
}

