/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.cache.LRUCache;
import org.ops4j.pax.web.service.undertow.internal.PathMatcher;

public class ContextAwarePathHandler
extends PathHandler {
    private final PathMatcher<HttpHandler> pathMatcher = new PathMatcher();
    private final LRUCache<String, PathMatcher.PathMatch<HttpHandler>> cache;

    public ContextAwarePathHandler(HttpHandler defaultHandler) {
        this(0);
        this.pathMatcher.addPrefixPath("/", defaultHandler);
    }

    public ContextAwarePathHandler(HttpHandler defaultHandler, int cacheSize) {
        this(cacheSize);
        this.pathMatcher.addPrefixPath("/", defaultHandler);
    }

    public ContextAwarePathHandler() {
        this(0);
    }

    public ContextAwarePathHandler(int cacheSize) {
        this.cache = cacheSize > 0 ? new LRUCache(cacheSize, -1, true) : null;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        PathMatcher.PathMatch<HttpHandler> match = null;
        boolean hit = false;
        if (this.cache != null) {
            match = (PathMatcher.PathMatch)this.cache.get((Object)exchange.getRelativePath());
            hit = true;
        }
        if (match == null) {
            match = this.pathMatcher.match(exchange.getRelativePath());
        }
        if (match.getValue() == null) {
            ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
            return;
        }
        if (hit) {
            this.cache.add((Object)exchange.getRelativePath(), match);
        }
        exchange.setRelativePath(match.getRemaining());
        if (exchange.getResolvedPath().isEmpty()) {
            exchange.setResolvedPath(match.getMatched());
        } else {
            StringBuilder sb = new StringBuilder(exchange.getResolvedPath().length() + match.getMatched().length());
            sb.append(exchange.getResolvedPath());
            sb.append(match.getMatched());
            exchange.setResolvedPath(sb.toString());
        }
        match.getValue().handleRequest(exchange);
    }

    @Deprecated
    public synchronized PathHandler addPath(String path, HttpHandler handler) {
        return this.addPrefixPath(path, handler);
    }

    public synchronized PathHandler addPrefixPath(String path, HttpHandler handler) {
        Handlers.handlerNotNull((HttpHandler)handler);
        this.pathMatcher.addPrefixPath(path, handler);
        return this;
    }

    public synchronized PathHandler addExactPath(String path, HttpHandler handler) {
        Handlers.handlerNotNull((HttpHandler)handler);
        this.pathMatcher.addExactPath(path, handler);
        return this;
    }

    @Deprecated
    public synchronized PathHandler removePath(String path) {
        return this.removePrefixPath(path);
    }

    public synchronized PathHandler removePrefixPath(String path) {
        this.pathMatcher.removePrefixPath(path);
        return this;
    }

    public synchronized PathHandler removeExactPath(String path) {
        this.pathMatcher.removeExactPath(path);
        return this;
    }

    public synchronized PathHandler clearPaths() {
        this.pathMatcher.clearPaths();
        return this;
    }

    public HttpHandler getDefaultHandler() {
        return this.pathMatcher.getDefaultHandler();
    }
}

