/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;

@Beta
public final class CopyHistory
implements Immutable {
    private static final CopyType[] VALUES = CopyType.values();
    private static final CopyHistory[][] CACHE = new CopyHistory[VALUES.length][];
    private static final CopyHistory ORIGINAL;
    private final short operations;
    private final short lastOperation;

    private CopyHistory(int operations, CopyType lastOperation) {
        this.operations = (short)operations;
        this.lastOperation = (short)lastOperation.ordinal();
    }

    public static CopyHistory original() {
        return ORIGINAL;
    }

    public static CopyHistory of(CopyType copyType, CopyHistory copyHistory) {
        return ORIGINAL.append(copyType, copyHistory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CopyHistory[] cacheArray(CopyType lastOperation) {
        int ordinal = lastOperation.ordinal();
        CopyHistory[] ret = CACHE[ordinal];
        if (ret != null) return ret;
        CopyHistory[][] copyHistoryArray = CACHE;
        synchronized (CACHE) {
            ret = CACHE[ordinal];
            if (ret != null) return ret;
            ret = new CopyHistory[1 << VALUES.length];
            CopyHistory.CACHE[ordinal] = ret;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CopyHistory cacheObject(CopyType lastOperation, int operations) {
        CopyHistory[] array = CopyHistory.cacheArray(lastOperation);
        CopyHistory ret = array[operations];
        if (ret != null) return ret;
        CopyHistory[] copyHistoryArray = array;
        synchronized (array) {
            ret = array[operations];
            if (ret != null) return ret;
            array[operations] = ret = new CopyHistory(operations, lastOperation);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return ret;
        }
    }

    public boolean contains(CopyType type) {
        return (this.operations & type.bit()) != 0;
    }

    public CopyType getLastOperation() {
        return VALUES[this.lastOperation];
    }

    @VisibleForTesting
    CopyHistory append(CopyType typeOfCopy, CopyHistory toAppend) {
        int newOperations = this.operations | toAppend.operations | typeOfCopy.bit();
        if (newOperations == this.operations && typeOfCopy.ordinal() == this.lastOperation) {
            return this;
        }
        return CopyHistory.cacheObject(typeOfCopy, newOperations);
    }

    public int hashCode() {
        return Integer.hashCode(this.operations | this.lastOperation << 16);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CopyHistory)) {
            return false;
        }
        CopyHistory other = (CopyHistory)obj;
        return this.operations == other.operations && this.lastOperation == other.lastOperation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lastOperation", (Object)this.getLastOperation()).add("operations", Arrays.stream(VALUES).filter(value -> (value.bit() & this.operations) != 0).collect(Collectors.toList())).toString();
    }

    static {
        Verify.verify((VALUES.length < 6 ? 1 : 0) != 0);
        ORIGINAL = CopyHistory.cacheObject(CopyType.ORIGINAL, CopyType.ORIGINAL.bit());
    }
}

