/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;

public abstract class NamespaceBehaviour<K, V, N extends IdentifierNamespace<K, V>>
implements Identifiable<Class<N>> {
    private final @NonNull Class<N> identifier;

    protected NamespaceBehaviour(Class<N> identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public static <K, V, N extends IdentifierNamespace<K, V>> @NonNull NamespaceBehaviour<K, V, N> global(Class<N> identifier) {
        return new StorageSpecific(identifier, StorageNodeType.GLOBAL);
    }

    public static <K, V, N extends IdentifierNamespace<K, V>> @NonNull NamespaceBehaviour<K, V, N> sourceLocal(Class<N> identifier) {
        return new StorageSpecific(identifier, StorageNodeType.SOURCE_LOCAL_SPECIAL);
    }

    public static <K, V, N extends IdentifierNamespace<K, V>> @NonNull NamespaceBehaviour<K, V, N> statementLocal(Class<N> identifier) {
        return new StorageSpecific(identifier, StorageNodeType.STATEMENT_LOCAL);
    }

    public static <K, V, N extends IdentifierNamespace<K, V>> @NonNull NamespaceBehaviour<K, V, N> rootStatementLocal(Class<N> identifier) {
        return new StorageSpecific(identifier, StorageNodeType.ROOT_STATEMENT_LOCAL);
    }

    public static <K, V, N extends IdentifierNamespace<K, V>> @NonNull NamespaceBehaviour<K, V, N> treeScoped(Class<N> identifier) {
        return new TreeScoped(identifier);
    }

    public abstract V getFrom(NamespaceStorageNode var1, K var2);

    public final Optional<Map.Entry<K, V>> getFrom(NamespaceStorageNode storage, NamespaceKeyCriterion<K> criterion) {
        Map<K, V> mappings = this.getAllFrom(storage);
        if (mappings == null) {
            return Optional.empty();
        }
        Map.Entry<K, V> match = null;
        for (Map.Entry<K, V> entry : mappings.entrySet()) {
            K key = entry.getKey();
            if (!criterion.match(key)) continue;
            if (match != null) {
                K selected = criterion.select(match.getKey(), key);
                if (selected.equals(match.getKey())) continue;
                Verify.verify((selected == key ? 1 : 0) != 0, (String)"Criterion %s selected invalid key %s from candidates [%s %s]", selected, match.getKey(), key);
            }
            match = entry;
        }
        return Optional.ofNullable(match);
    }

    public abstract Map<K, V> getAllFrom(NamespaceStorageNode var1);

    public abstract void addTo(NamespaceStorageNode var1, K var2, V var3);

    public Class<N> getIdentifier() {
        return this.identifier;
    }

    protected final V getFromLocalStorage(NamespaceStorageNode storage, K key) {
        return storage.getFromLocalStorage(this.getIdentifier(), key);
    }

    protected final Map<K, V> getAllFromLocalStorage(NamespaceStorageNode storage) {
        return storage.getAllFromLocalStorage(this.getIdentifier());
    }

    protected final void addToStorage(NamespaceStorageNode storage, K key, V value) {
        storage.putToLocalStorage(this.getIdentifier(), key, value);
    }

    protected static NamespaceStorageNode findClosestTowardsRoot(NamespaceStorageNode storage, StorageNodeType type) {
        NamespaceStorageNode current;
        for (current = storage; current != null && current.getStorageNodeType() != type; current = current.getParentNamespaceStorage()) {
        }
        return current;
    }

    public String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("identifier", (Object)this.identifier.getName());
    }

    static final class TreeScoped<K, V, N extends IdentifierNamespace<K, V>>
    extends NamespaceBehaviour<K, V, N> {
        TreeScoped(Class<N> identifier) {
            super(identifier);
        }

        @Override
        public V getFrom(NamespaceStorageNode storage, K key) {
            for (NamespaceStorageNode current = storage; current != null; current = current.getParentNamespaceStorage()) {
                Object val = this.getFromLocalStorage(current, key);
                if (val == null) continue;
                return val;
            }
            return null;
        }

        @Override
        public Map<K, V> getAllFrom(NamespaceStorageNode storage) {
            for (NamespaceStorageNode current = storage; current != null; current = current.getParentNamespaceStorage()) {
                Map val = this.getAllFromLocalStorage(current);
                if (val == null) continue;
                return val;
            }
            return null;
        }

        @Override
        public void addTo(NamespaceStorageNode storage, K key, V value) {
            this.addToStorage(storage, key, value);
        }
    }

    static final class StorageSpecific<K, V, N extends IdentifierNamespace<K, V>>
    extends NamespaceBehaviour<K, V, N> {
        StorageNodeType storageType;

        StorageSpecific(Class<N> identifier, StorageNodeType type) {
            super(identifier);
            this.storageType = Objects.requireNonNull(type);
        }

        @Override
        public V getFrom(NamespaceStorageNode storage, K key) {
            NamespaceStorageNode current = StorageSpecific.findClosestTowardsRoot(storage, this.storageType);
            return this.getFromLocalStorage(current, key);
        }

        @Override
        public Map<K, V> getAllFrom(NamespaceStorageNode storage) {
            NamespaceStorageNode current = storage;
            while (current.getStorageNodeType() != this.storageType) {
                current = current.getParentNamespaceStorage();
            }
            return this.getAllFromLocalStorage(current);
        }

        @Override
        public void addTo(NamespaceStorageNode storage, K key, V value) {
            NamespaceStorageNode current = StorageSpecific.findClosestTowardsRoot(storage, this.storageType);
            this.addToStorage(current, key, value);
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper.add("type", (Object)this.storageType));
        }
    }

    public static interface NamespaceStorageNode {
        public StorageNodeType getStorageNodeType();

        public @Nullable NamespaceStorageNode getParentNamespaceStorage();

        public <K, V, N extends IdentifierNamespace<K, V>> @Nullable V getFromLocalStorage(Class<N> var1, K var2);

        public <K, V, N extends IdentifierNamespace<K, V>> @Nullable Map<K, V> getAllFromLocalStorage(Class<N> var1);

        public <K, V, N extends IdentifierNamespace<K, V>> @Nullable V putToLocalStorage(Class<N> var1, K var2, V var3);

        public <K, V, N extends IdentifierNamespace<K, V>> @Nullable V putToLocalStorageIfAbsent(Class<N> var1, K var2, V var3);
    }

    public static interface Registry {
        public <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviour<K, V, N> getNamespaceBehaviour(Class<N> var1);
    }

    public static enum StorageNodeType {
        GLOBAL,
        SOURCE_LOCAL_SPECIAL,
        STATEMENT_LOCAL,
        ROOT_STATEMENT_LOCAL;

    }
}

