/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;

@Beta
public abstract class NamespaceKeyCriterion<K> {
    public static NamespaceKeyCriterion<SourceIdentifier> latestRevisionModule(String moduleName) {
        return new LatestRevisionModule(moduleName);
    }

    public abstract boolean match(@NonNull K var1);

    public abstract K select(@NonNull K var1, @NonNull K var2);

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    private static final class LatestRevisionModule
    extends NamespaceKeyCriterion<SourceIdentifier> {
        private final String moduleName;

        LatestRevisionModule(String moduleName) {
            this.moduleName = Objects.requireNonNull(moduleName);
        }

        @Override
        public boolean match(SourceIdentifier key) {
            return this.moduleName.equals(key.getName());
        }

        @Override
        public SourceIdentifier select(SourceIdentifier first, SourceIdentifier second) {
            return Revision.compare((Optional)first.getRevision(), (Optional)second.getRevision()) >= 0 ? first : second;
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return toStringHelper.add("moduleName", (Object)this.moduleName);
        }
    }
}

