/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.meta;

import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public interface StmtContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> {
    public @NonNull StatementSource getStatementSource();

    public @NonNull StatementSourceReference getStatementSourceReference();

    public @NonNull StatementDefinition getPublicDefinition();

    public @Nullable StmtContext<?, ?, ?> getParentContext();

    default public @NonNull StmtContext<?, ?, ?> coerceParentContext() {
        return (StmtContext)Verify.verifyNotNull(this.getParentContext(), (String)"Root context %s does not have a parent", (Object[])new Object[]{this});
    }

    public @Nullable String rawStatementArgument();

    default public @NonNull String coerceRawStatementArgument() {
        return (String)Verify.verifyNotNull((Object)this.rawStatementArgument(), (String)"Statement context %s does not have an argument", (Object[])new Object[]{this});
    }

    public @Nullable A getStatementArgument();

    default public @NonNull A coerceStatementArgument() {
        return (A)Verify.verifyNotNull(this.getStatementArgument(), (String)"Statement context %s does not have an argument", (Object[])new Object[]{this});
    }

    public @NonNull Optional<SchemaPath> getSchemaPath();

    public boolean isConfiguration();

    public boolean isEnabledSemanticVersioning();

    public <K, V, T extends K, N extends IdentifierNamespace<K, V>> @NonNull V getFromNamespace(Class<N> var1, T var2);

    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromNamespace(Class<N> var1);

    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromCurrentStmtCtxNamespace(Class<N> var1);

    public @NonNull StmtContext<?, ?, ?> getRoot();

    public @NonNull Collection<? extends StmtContext<?, ?, ?>> declaredSubstatements();

    public @NonNull Collection<? extends StmtContext<?, ?, ?>> effectiveSubstatements();

    default public Iterable<? extends StmtContext<?, ?, ?>> allSubstatements() {
        return Iterables.concat(this.declaredSubstatements(), this.effectiveSubstatements());
    }

    default public Stream<? extends StmtContext<?, ?, ?>> allSubstatementsStream() {
        return Streams.concat((Stream[])new Stream[]{this.declaredSubstatements().stream(), this.effectiveSubstatements().stream()});
    }

    public D buildDeclared();

    public E buildEffective();

    public boolean isSupportedToBuildEffective();

    public Collection<? extends StmtContext<?, ?, ?>> getEffectOfStatement();

    public CopyHistory getCopyHistory();

    public boolean isSupportedByFeatures();

    public Optional<StmtContext<?, ?, ?>> getOriginalCtx();

    public ModelProcessingPhase getCompletedPhase();

    public @NonNull YangVersion getRootVersion();

    public static interface Mutable<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
    extends StmtContext<A, D, E> {
        @Override
        public Mutable<?, ?, ?> getParentContext();

        @Override
        default public Mutable<?, ?, ?> coerceParentContext() {
            return (Mutable)Verify.verifyNotNull((Object)this.getParentContext(), (String)"Root context %s does not have a parent", (Object[])new Object[]{this});
        }

        public <K, V, T extends K, U extends V, N extends IdentifierNamespace<K, V>> void addToNs(Class<N> var1, T var2, U var3);

        @Override
        public Mutable<?, ?, ?> getRoot();

        public <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> Mutable<X, Y, Z> childCopyOf(StmtContext<X, Y, Z> var1, CopyType var2, @Nullable QNameModule var3);

        default public <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> Mutable<X, Y, Z> childCopyOf(StmtContext<X, Y, Z> stmt, CopyType type) {
            return this.childCopyOf(stmt, type, null);
        }

        public @NonNull Collection<? extends Mutable<?, ?, ?>> mutableDeclaredSubstatements();

        public @NonNull Collection<? extends Mutable<?, ?, ?>> mutableEffectiveSubstatements();

        public @NonNull ModelActionBuilder newInferenceAction(@NonNull ModelProcessingPhase var1);

        public <K, KT extends K, N extends StatementNamespace<K, ?, ?>> void addContext(Class<N> var1, KT var2, StmtContext<?, ?, ?> var3);

        public void setRootVersion(YangVersion var1);

        public void addMutableStmtToSeal(MutableStatement var1);

        public void addRequiredSource(SourceIdentifier var1);

        public void addAsEffectOfStatement(StmtContext<?, ?, ?> var1);

        public void addAsEffectOfStatement(Collection<? extends StmtContext<?, ?, ?>> var1);

        public void setRootIdentifier(SourceIdentifier var1);

        public void setIsSupportedToBuildEffective(boolean var1);

        public void setCompletedPhase(ModelProcessingPhase var1);
    }
}

